/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ElementRef, InjectionToken, NgZone, OnDestroy, OnInit } from '@angular/core';
import { NzWaveRenderer } from './nz-wave-renderer';
import * as ɵngcc0 from '@angular/core';
export interface NzWaveConfig {
    disabled?: boolean;
}
export declare const NZ_WAVE_GLOBAL_DEFAULT_CONFIG: NzWaveConfig;
export declare const NZ_WAVE_GLOBAL_CONFIG: InjectionToken<NzWaveConfig>;
export declare function NZ_WAVE_GLOBAL_CONFIG_FACTORY(): NzWaveConfig;
export declare class NzWaveDirective implements OnInit, OnDestroy {
    private ngZone;
    private elementRef;
    private config;
    private animationType;
    nzWaveExtraNode: boolean;
    private waveRenderer;
    private waveDisabled;
    readonly disabled: boolean;
    readonly rendererRef: NzWaveRenderer;
    constructor(ngZone: NgZone, elementRef: ElementRef, config: NzWaveConfig, animationType: string);
    isConfigDisabled(): boolean;
    ngOnDestroy(): void;
    ngOnInit(): void;
    renderWaveIfEnabled(): void;
    disable(): void;
    enable(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzWaveDirective>;
    static ɵdir: ɵngcc0.ɵɵDirectiveDefWithMeta<NzWaveDirective, "[nz-wave]", ["nzWave"], {
    "nzWaveExtraNode": "nzWaveExtraNode";
}, {}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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