/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { EventEmitter, TemplateRef } from '@angular/core';
import { CandyDate, FunctionProp } from 'ng-zorro-antd/core';
import { NzCalendarI18nInterface } from 'ng-zorro-antd/i18n';
import { DisabledDateFn, PanelMode } from '../../standard-types';
import * as ɵngcc0 from '@angular/core';
export declare class InnerPopupComponent {
    showWeek: boolean;
    locale: NzCalendarI18nInterface;
    showTimePicker: boolean;
    timeOptions: any;
    enablePrev: boolean;
    enableNext: boolean;
    disabledDate: DisabledDateFn;
    dateRender: FunctionProp<TemplateRef<Date> | string>;
    selectedValue: CandyDate[];
    hoverValue: CandyDate[];
    panelMode: PanelMode;
    readonly panelModeChange: EventEmitter<PanelMode>;
    value: CandyDate;
    readonly headerChange: EventEmitter<CandyDate>;
    readonly selectDate: EventEmitter<CandyDate>;
    readonly selectTime: EventEmitter<CandyDate>;
    readonly dayHover: EventEmitter<CandyDate>;
    prefixCls: string;
    onSelectTime(date: Date): void;
    onSelectDate(date: CandyDate | Date): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<InnerPopupComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<InnerPopupComponent, "inner-popup", ["innerPopup"], {
    "showWeek": "showWeek";
    "locale": "locale";
    "showTimePicker": "showTimePicker";
    "timeOptions": "timeOptions";
    "enablePrev": "enablePrev";
    "enableNext": "enableNext";
    "disabledDate": "disabledDate";
    "dateRender": "dateRender";
    "selectedValue": "selectedValue";
    "hoverValue": "hoverValue";
    "panelMode": "panelMode";
    "value": "value";
}, {
    "panelModeChange": "panelModeChange";
    "headerChange": "headerChange";
    "selectDate": "selectDate";
    "selectTime": "selectTime";
    "dayHover": "dayHover";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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