/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { Overlay } from '@angular/cdk/overlay';
import { NzDrawerOptions, NzDrawerOptionsOfComponent } from './nz-drawer-options';
import { NzDrawerRef } from './nz-drawer-ref';
import * as ɵngcc0 from '@angular/core';
export declare class DrawerBuilderForService<R> {
    private overlay;
    private options;
    private drawerRef;
    private overlayRef;
    private unsubscribe$;
    constructor(overlay: Overlay, options: NzDrawerOptions);
    getInstance(): NzDrawerRef<R>;
    createDrawer(): void;
    updateOptions(options: NzDrawerOptionsOfComponent): void;
}
export declare class NzDrawerService {
    private overlay;
    constructor(overlay: Overlay);
    create<T = any, D = any, R = any>(options: NzDrawerOptions<T, D>): NzDrawerRef<R>;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzDrawerService>;
    static ɵprov: ɵngcc0.ɵɵInjectableDef<NzDrawerService>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibnotZHJhd2VyLnNlcnZpY2UuZC50cyIsInNvdXJjZXMiOlsibnotZHJhd2VyLnNlcnZpY2UuZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7OztBQUNBIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEFsaWJhYmEuY29tIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogVXNlIG9mIHRoaXMgc291cmNlIGNvZGUgaXMgZ292ZXJuZWQgYnkgYW4gTUlULXN0eWxlIGxpY2Vuc2UgdGhhdCBjYW4gYmVcbiAqIGZvdW5kIGluIHRoZSBMSUNFTlNFIGZpbGUgYXQgaHR0cHM6Ly9naXRodWIuY29tL05HLVpPUlJPL25nLXpvcnJvLWFudGQvYmxvYi9tYXN0ZXIvTElDRU5TRVxuICovXG5pbXBvcnQgeyBPdmVybGF5IH0gZnJvbSAnQGFuZ3VsYXIvY2RrL292ZXJsYXknO1xuaW1wb3J0IHsgTnpEcmF3ZXJPcHRpb25zLCBOekRyYXdlck9wdGlvbnNPZkNvbXBvbmVudCB9IGZyb20gJy4vbnotZHJhd2VyLW9wdGlvbnMnO1xuaW1wb3J0IHsgTnpEcmF3ZXJSZWYgfSBmcm9tICcuL256LWRyYXdlci1yZWYnO1xuZXhwb3J0IGRlY2xhcmUgY2xhc3MgRHJhd2VyQnVpbGRlckZvclNlcnZpY2U8Uj4ge1xuICAgIHByaXZhdGUgb3ZlcmxheTtcbiAgICBwcml2YXRlIG9wdGlvbnM7XG4gICAgcHJpdmF0ZSBkcmF3ZXJSZWY7XG4gICAgcHJpdmF0ZSBvdmVybGF5UmVmO1xuICAgIHByaXZhdGUgdW5zdWJzY3JpYmUkO1xuICAgIGNvbnN0cnVjdG9yKG92ZXJsYXk6IE92ZXJsYXksIG9wdGlvbnM6IE56RHJhd2VyT3B0aW9ucyk7XG4gICAgZ2V0SW5zdGFuY2UoKTogTnpEcmF3ZXJSZWY8Uj47XG4gICAgY3JlYXRlRHJhd2VyKCk6IHZvaWQ7XG4gICAgdXBkYXRlT3B0aW9ucyhvcHRpb25zOiBOekRyYXdlck9wdGlvbnNPZkNvbXBvbmVudCk6IHZvaWQ7XG59XG5leHBvcnQgZGVjbGFyZSBjbGFzcyBOekRyYXdlclNlcnZpY2Uge1xuICAgIHByaXZhdGUgb3ZlcmxheTtcbiAgICBjb25zdHJ1Y3RvcihvdmVybGF5OiBPdmVybGF5KTtcbiAgICBjcmVhdGU8VCA9IGFueSwgRCA9IGFueSwgUiA9IGFueT4ob3B0aW9uczogTnpEcmF3ZXJPcHRpb25zPFQsIEQ+KTogTnpEcmF3ZXJSZWY8Uj47XG59XG4iXX0=