/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ChangeDetectorRef, OnInit } from '@angular/core';
import { NzConfigService } from 'ng-zorro-antd/core';
import { NzMessageConfigLegacy } from './nz-message-config';
import { NzMessageDataFilled, NzMessageDataOptions } from './nz-message.definitions';
import * as ɵngcc0 from '@angular/core';
export declare class NzMessageContainerComponent implements OnInit {
    protected cdr: ChangeDetectorRef;
    protected nzConfigService: NzConfigService;
    messages: NzMessageDataFilled[];
    config: Required<NzMessageConfigLegacy>;
    top: string | null;
    constructor(cdr: ChangeDetectorRef, nzConfigService: NzConfigService, defaultConfig: NzMessageConfigLegacy, config: NzMessageConfigLegacy);
    ngOnInit(): void;
    setConfig(config?: NzMessageConfigLegacy): void;
    /**
     * Create a new message.
     * @param message Parsed message configuration.
     */
    createMessage(message: NzMessageDataFilled): void;
    /**
     * Remove a message by `messageId`.
     * @param messageId Id of the message to be removed.
     * @param userAction Whether this is closed by user interaction.
     */
    removeMessage(messageId: string, userAction?: boolean): void;
    /**
     * Remove all messages.
     */
    removeMessageAll(): void;
    protected subscribeConfigChange(): void;
    protected mergeMessageConfig(config?: NzMessageConfigLegacy): Required<NzMessageConfigLegacy>;
    /**
     * Merge default options and custom message options
     * @param options
     */
    protected _mergeMessageOptions(options?: NzMessageDataOptions): NzMessageDataOptions;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzMessageContainerComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzMessageContainerComponent, "nz-message-container", ["nzMessageContainer"], {}, {}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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