/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { OnChanges, OnDestroy, OnInit, SimpleChanges } from '@angular/core';
import { NgStyleInterface, NzConfigService } from 'ng-zorro-antd/core';
import { NzProgressCirclePath, NzProgressFormatter, NzProgressGapPositionType, NzProgressStatusType, NzProgressStrokeColorType, NzProgressStrokeLinecapType, NzProgressTypeType } from './nz-progress.definitions';
import * as ɵngcc0 from '@angular/core';
export declare class NzProgressComponent implements OnChanges, OnInit, OnDestroy {
    nzConfigService: NzConfigService;
    nzShowInfo: boolean;
    nzWidth: number;
    nzStrokeColor: NzProgressStrokeColorType;
    nzSize: 'default' | 'small';
    nzFormat?: NzProgressFormatter;
    nzSuccessPercent?: number;
    nzPercent: number;
    nzStrokeWidth: number;
    nzGapDegree: number;
    nzStatus: NzProgressStatusType;
    nzType: NzProgressTypeType;
    nzGapPosition: NzProgressGapPositionType;
    nzStrokeLinecap: NzProgressStrokeLinecapType;
    /** Gradient style when `nzType` is `line`. */
    lineGradient: string | null;
    /** If user uses gradient color. */
    isGradient: boolean;
    /**
     * Each progress whose `nzType` is circle or dashboard should have unique id to
     * define `<linearGradient>`.
     */
    gradientId: number;
    /** Paths to rendered in the template. */
    progressCirclePath: NzProgressCirclePath[];
    circleGradient: Array<{
        offset: string;
        color: string;
    }>;
    trailPathStyle: NgStyleInterface;
    pathString: string;
    icon: string;
    trackByFn: (index: number) => string;
    readonly formatter: NzProgressFormatter;
    readonly status: NzProgressStatusType;
    readonly strokeWidth: number;
    readonly isCircleStyle: boolean;
    private cachedStatus;
    private inferredStatus;
    private destroy$;
    constructor(nzConfigService: NzConfigService);
    ngOnChanges(changes: SimpleChanges): void;
    ngOnInit(): void;
    ngOnDestroy(): void;
    private updateIcon;
    /**
     * Calculate paths when the type is circle or dashboard.
     */
    private getCirclePaths;
    private setStrokeColor;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzProgressComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzProgressComponent, "nz-progress", ["nzProgress"], {
    "nzWidth": "nzWidth";
    "nzPercent": "nzPercent";
    "nzType": "nzType";
    "nzShowInfo": "nzShowInfo";
    "nzStrokeColor": "nzStrokeColor";
    "nzSize": "nzSize";
    "nzFormat": "nzFormat";
    "nzSuccessPercent": "nzSuccessPercent";
    "nzStrokeWidth": "nzStrokeWidth";
    "nzGapDegree": "nzGapDegree";
    "nzStatus": "nzStatus";
    "nzGapPosition": "nzGapPosition";
    "nzStrokeLinecap": "nzStrokeLinecap";
}, {}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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