/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ChangeDetectorRef, EventEmitter, OnChanges, OnDestroy, OnInit, SimpleChanges } from '@angular/core';
import { Subject } from 'rxjs';
import { NzDropdownMenuComponent } from 'ng-zorro-antd/dropdown';
import { NzI18nInterface, NzI18nService } from 'ng-zorro-antd/i18n';
import * as ɵngcc0 from '@angular/core';
export declare type NzThFilterType = Array<{
    text: string;
    value: any;
    byDefault?: boolean;
}>;
export interface NzThItemInterface {
    text: string;
    value: any;
    checked: boolean;
}
export declare class NzThComponent implements OnChanges, OnInit, OnDestroy {
    private cdr;
    private i18n;
    hasFilterValue: boolean;
    filterVisible: boolean;
    multipleFilterList: NzThItemInterface[];
    singleFilterList: NzThItemInterface[];
    locale: NzI18nInterface['Table'];
    nzWidthChange$: Subject<unknown>;
    private destroy$;
    private hasDefaultFilter;
    nzDropdownMenuComponent: NzDropdownMenuComponent;
    nzSelections: Array<{
        text: string;
        onSelect(...args: any[]): any;
    }>;
    nzChecked: boolean;
    nzDisabled: boolean;
    nzIndeterminate: boolean;
    nzSortKey: string;
    nzFilterMultiple: boolean;
    nzWidth: string;
    nzLeft: string;
    nzRight: string;
    nzAlign: 'left' | 'right' | 'center';
    nzSort: 'ascend' | 'descend' | null;
    nzFilters: NzThFilterType;
    nzExpand: boolean;
    nzShowCheckbox: boolean;
    nzCustomFilter: boolean;
    nzShowSort: boolean;
    nzShowFilter: boolean;
    nzShowRowSelection: boolean;
    readonly nzCheckedChange: EventEmitter<boolean>;
    readonly nzSortChange: EventEmitter<string | null>;
    readonly nzSortChangeWithKey: EventEmitter<{
        key: string;
        value: string | null;
    }>;
    readonly nzFilterChange: EventEmitter<any>;
    updateSortValue(): void;
    setSortValue(value: 'ascend' | 'descend' | null): void;
    readonly filterList: NzThItemInterface[];
    readonly filterValue: any;
    updateFilterStatus(): void;
    search(): void;
    reset(): void;
    checkMultiple(filter: NzThItemInterface): void;
    checkSingle(filter: NzThItemInterface): void;
    hideDropDown(): void;
    dropDownVisibleChange(value: boolean): void;
    initMultipleFilterList(force?: boolean): void;
    initSingleFilterList(force?: boolean): void;
    checkDefaultFilters(): void;
    marForCheck(): void;
    constructor(cdr: ChangeDetectorRef, i18n: NzI18nService);
    ngOnInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngOnDestroy(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzThComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzThComponent, "th:not(.nz-disable-th):not([mat-sort-header]):not([mat-header-cell])", never, {
    "nzSelections": "nzSelections";
    "nzChecked": "nzChecked";
    "nzDisabled": "nzDisabled";
    "nzIndeterminate": "nzIndeterminate";
    "nzFilterMultiple": "nzFilterMultiple";
    "nzSort": "nzSort";
    "nzFilters": "nzFilters";
    "nzExpand": "nzExpand";
    "nzShowCheckbox": "nzShowCheckbox";
    "nzCustomFilter": "nzCustomFilter";
    "nzShowSort": "nzShowSort";
    "nzShowFilter": "nzShowFilter";
    "nzShowRowSelection": "nzShowRowSelection";
    "nzSortKey": "nzSortKey";
    "nzWidth": "nzWidth";
    "nzLeft": "nzLeft";
    "nzRight": "nzRight";
    "nzAlign": "nzAlign";
}, {
    "nzCheckedChange": "nzCheckedChange";
    "nzSortChange": "nzSortChange";
    "nzSortChangeWithKey": "nzSortChangeWithKey";
    "nzFilterChange": "nzFilterChange";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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