/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
/** code from https://github.com/angular/material2 */
import { Direction, Directionality } from '@angular/cdk/bidi';
import { Platform } from '@angular/cdk/platform';
import { AfterContentChecked, AfterContentInit, ChangeDetectorRef, ElementRef, EventEmitter, NgZone, OnDestroy, QueryList, Renderer2, TemplateRef } from '@angular/core';
import { NzDomEventService } from 'ng-zorro-antd/core';
import { Subscription } from 'rxjs';
import { NzTabLabelDirective } from './nz-tab-label.directive';
import { NzTabsInkBarDirective } from './nz-tabs-ink-bar.directive';
import { NzTabPositionMode } from './nz-tabset.component';
import * as ɵngcc0 from '@angular/core';
export declare type ScrollDirection = 'after' | 'before';
export declare class NzTabsNavComponent implements AfterContentChecked, AfterContentInit, OnDestroy {
    elementRef: ElementRef;
    private ngZone;
    private renderer;
    private cdr;
    private platform;
    private nzDomEventService;
    private dir;
    private _tabPositionMode;
    private _scrollDistance;
    private _selectedIndex;
    /** Cached text content of the header. */
    private currentTextContent;
    private destroy$;
    showPaginationControls: boolean;
    disableScrollAfter: boolean;
    disableScrollBefore: boolean;
    selectedIndexChanged: boolean;
    realignInkBar: Subscription | null;
    tabLabelCount: number;
    scrollDistanceChanged: boolean;
    listOfNzTabLabelDirective: QueryList<NzTabLabelDirective>;
    nzTabsInkBarDirective: NzTabsInkBarDirective;
    navContainerElement: ElementRef<HTMLDivElement>;
    navListElement: ElementRef<HTMLDivElement>;
    scrollListElement: ElementRef<HTMLDivElement>;
    readonly nzOnNextClick: EventEmitter<void>;
    readonly nzOnPrevClick: EventEmitter<void>;
    nzTabBarExtraContent: TemplateRef<void>;
    nzAnimated: boolean;
    nzHideBar: boolean;
    nzShowPagination: boolean;
    nzType: string;
    nzPositionMode: NzTabPositionMode;
    selectedIndex: number;
    constructor(elementRef: ElementRef, ngZone: NgZone, renderer: Renderer2, cdr: ChangeDetectorRef, platform: Platform, nzDomEventService: NzDomEventService, dir: Directionality);
    onContentChanges(): void;
    scrollHeader(scrollDir: ScrollDirection): void;
    ngAfterContentChecked(): void;
    ngAfterContentInit(): void;
    ngOnDestroy(): void;
    updateTabScrollPosition(): void;
    updatePagination(): void;
    checkPaginationEnabled(): void;
    scrollToLabel(labelIndex: number): void;
    checkScrollingControls(): void;
    /**
     * Determines what is the maximum length in pixels that can be set for the scroll distance. This
     * is equal to the difference in width between the tab list container and tab header container.
     *
     * This is an expensive call that forces a layout reflow to compute box and scroll metrics and
     * should be called sparingly.
     */
    getMaxScrollDistance(): number;
    /** Sets the distance in pixels that the tab header should be transformed in the X-axis. */
    scrollDistance: number;
    readonly viewWidthHeightPix: number;
    readonly navContainerScrollPaddingPix: number;
    readonly tabListScrollWidthHeightPix: number;
    readonly tabListScrollOffSetWidthHeight: number;
    getLayoutDirection(): Direction;
    alignInkBarToSelectedTab(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzTabsNavComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzTabsNavComponent, "[nz-tabs-nav]", ["nzTabsNav"], {
    "nzAnimated": "nzAnimated";
    "nzHideBar": "nzHideBar";
    "nzShowPagination": "nzShowPagination";
    "nzType": "nzType";
    "nzPositionMode": "nzPositionMode";
    "selectedIndex": "selectedIndex";
    "nzTabBarExtraContent": "nzTabBarExtraContent";
}, {
    "nzOnNextClick": "nzOnNextClick";
    "nzOnPrevClick": "nzOnPrevClick";
}, ["listOfNzTabLabelDirective"]>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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