"use strict";
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Zone.__load_patch('cordova', function (global, Zone, api) {
    if (global.cordova) {
        var SUCCESS_SOURCE_1 = 'cordova.exec.success';
        var ERROR_SOURCE_1 = 'cordova.exec.error';
        var FUNCTION_1 = 'function';
        var nativeExec_1 = api.patchMethod(global.cordova, 'exec', function () { return function (self, args) {
            if (args.length > 0 && typeof args[0] === FUNCTION_1) {
                args[0] = Zone.current.wrap(args[0], SUCCESS_SOURCE_1);
            }
            if (args.length > 1 && typeof args[1] === FUNCTION_1) {
                args[1] = Zone.current.wrap(args[1], ERROR_SOURCE_1);
            }
            return nativeExec_1.apply(self, args);
        }; });
    }
});
Zone.__load_patch('cordova.FileReader', function (global, Zone) {
    if (global.cordova && typeof global['FileReader'] !== 'undefined') {
        document.addEventListener('deviceReady', function () {
            var FileReader = global['FileReader'];
            ['abort', 'error', 'load', 'loadstart', 'loadend', 'progress'].forEach(function (prop) {
                var eventNameSymbol = Zone.__symbol__('ON_PROPERTY' + prop);
                Object.defineProperty(FileReader.prototype, eventNameSymbol, {
                    configurable: true,
                    get: function () { return this._realReader && this._realReader[eventNameSymbol]; }
                });
            });
        });
    }
});
//# sourceMappingURL=data:application/json;base64,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