/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { NgClass } from './ng_class';
import { NgComponentOutlet } from './ng_component_outlet';
import { NgForOf, NgForOfContext } from './ng_for_of';
import { NgIf, NgIfContext } from './ng_if';
import { NgPlural, NgPluralCase } from './ng_plural';
import { NgStyle } from './ng_style';
import { NgSwitch, NgSwitchCase, NgSwitchDefault } from './ng_switch';
import { NgTemplateOutlet } from './ng_template_outlet';
export { NgClass, NgComponentOutlet, NgForOf, NgForOfContext, NgIf, NgIfContext, NgPlural, NgPluralCase, NgStyle, NgSwitch, NgSwitchCase, NgSwitchDefault, NgTemplateOutlet, };
/**
 * A collection of Angular directives that are likely to be used in each and every Angular
 * application.
 */
export var COMMON_DIRECTIVES = [
    NgClass,
    NgComponentOutlet,
    NgForOf,
    NgIf,
    NgTemplateOutlet,
    NgStyle,
    NgSwitch,
    NgSwitchCase,
    NgSwitchDefault,
    NgPlural,
    NgPluralCase,
];
//# sourceMappingURL=data:application/json;base64,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