/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler-cli/src/ngtsc/typecheck/src/oob", ["require", "exports", "typescript", "@angular/compiler-cli/src/ngtsc/diagnostics", "@angular/compiler-cli/src/ngtsc/typecheck/src/diagnostics"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ts = require("typescript");
    var diagnostics_1 = require("@angular/compiler-cli/src/ngtsc/diagnostics");
    var diagnostics_2 = require("@angular/compiler-cli/src/ngtsc/typecheck/src/diagnostics");
    var OutOfBandDiagnosticRecorderImpl = /** @class */ (function () {
        function OutOfBandDiagnosticRecorderImpl(resolver) {
            this.resolver = resolver;
            this._diagnostics = [];
        }
        Object.defineProperty(OutOfBandDiagnosticRecorderImpl.prototype, "diagnostics", {
            get: function () { return this._diagnostics; },
            enumerable: true,
            configurable: true
        });
        OutOfBandDiagnosticRecorderImpl.prototype.missingReferenceTarget = function (templateId, ref) {
            var mapping = this.resolver.getSourceMapping(templateId);
            var value = ref.value.trim();
            var errorMsg = "No directive found with exportAs '" + value + "'.";
            this._diagnostics.push(diagnostics_2.makeTemplateDiagnostic(mapping, ref.valueSpan || ref.sourceSpan, ts.DiagnosticCategory.Error, diagnostics_1.ngErrorCode(diagnostics_1.ErrorCode.MISSING_REFERENCE_TARGET), errorMsg));
        };
        OutOfBandDiagnosticRecorderImpl.prototype.missingPipe = function (templateId, ast) {
            var mapping = this.resolver.getSourceMapping(templateId);
            var errorMsg = "No pipe found with name '" + ast.name + "'.";
            var sourceSpan = this.resolver.toParseSourceSpan(templateId, ast.nameSpan);
            if (sourceSpan === null) {
                throw new Error("Assertion failure: no SourceLocation found for usage of pipe '" + ast.name + "'.");
            }
            this._diagnostics.push(diagnostics_2.makeTemplateDiagnostic(mapping, sourceSpan, ts.DiagnosticCategory.Error, diagnostics_1.ngErrorCode(diagnostics_1.ErrorCode.MISSING_PIPE), errorMsg));
        };
        OutOfBandDiagnosticRecorderImpl.prototype.illegalAssignmentToTemplateVar = function (templateId, assignment, target) {
            var mapping = this.resolver.getSourceMapping(templateId);
            var errorMsg = "Cannot use variable '" + assignment.name + "' as the left-hand side of an assignment expression. Template variables are read-only.";
            var sourceSpan = this.resolver.toParseSourceSpan(templateId, assignment.sourceSpan);
            if (sourceSpan === null) {
                throw new Error("Assertion failure: no SourceLocation found for property binding.");
            }
            this._diagnostics.push(diagnostics_2.makeTemplateDiagnostic(mapping, sourceSpan, ts.DiagnosticCategory.Error, diagnostics_1.ngErrorCode(diagnostics_1.ErrorCode.WRITE_TO_READ_ONLY_VARIABLE), errorMsg, {
                text: "The variable " + assignment.name + " is declared here.",
                span: target.valueSpan || target.sourceSpan,
            }));
        };
        OutOfBandDiagnosticRecorderImpl.prototype.duplicateTemplateVar = function (templateId, variable, firstDecl) {
            var mapping = this.resolver.getSourceMapping(templateId);
            var errorMsg = "Cannot redeclare variable '" + variable.name + "' as it was previously declared elsewhere for the same template.";
            // The allocation of the error here is pretty useless for variables declared in microsyntax,
            // since the sourceSpan refers to the entire microsyntax property, not a span for the specific
            // variable in question.
            //
            // TODO(alxhub): allocate to a tighter span once one is available.
            this._diagnostics.push(diagnostics_2.makeTemplateDiagnostic(mapping, variable.sourceSpan, ts.DiagnosticCategory.Error, diagnostics_1.ngErrorCode(diagnostics_1.ErrorCode.DUPLICATE_VARIABLE_DECLARATION), errorMsg, {
                text: "The variable '" + firstDecl.name + "' was first declared here.",
                span: firstDecl.sourceSpan,
            }));
        };
        return OutOfBandDiagnosticRecorderImpl;
    }());
    exports.OutOfBandDiagnosticRecorderImpl = OutOfBandDiagnosticRecorderImpl;
});
//# sourceMappingURL=data:application/json;base64,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