/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Directive, ElementRef, Input, Renderer2 } from '@angular/core';
import { alreadyHasAThemeSuffix, getNameAndNamespace, isIconDefinition, warn, withSuffix } from '../utils';
import { IconService } from './icon.service';
export class IconDirective {
    /**
     * @param {?} _iconService
     * @param {?} _elementRef
     * @param {?} _renderer
     */
    constructor(_iconService, _elementRef, _renderer) {
        this._iconService = _iconService;
        this._elementRef = _elementRef;
        this._renderer = _renderer;
    }
    /**
     * @param {?} changes
     * @return {?}
     */
    ngOnChanges(changes) {
        if (changes.type || changes.theme || changes.twoToneColor) {
            this._changeIcon();
        }
    }
    /**
     * Render a new icon in the current element. Remove the icon when `type` is falsy.
     * @protected
     * @return {?}
     */
    _changeIcon() {
        return new Promise((/**
         * @param {?} resolve
         * @return {?}
         */
        resolve => {
            if (!this.type) {
                this._clearSVGElement();
                resolve(null);
            }
            else {
                this._iconService.getRenderedContent(this._parseIconType(this.type, this.theme), this.twoToneColor).subscribe((/**
                 * @param {?} svg
                 * @return {?}
                 */
                svg => {
                    this._setSVGElement(svg);
                    resolve(svg);
                }));
            }
        }));
    }
    /**
     * Parse a icon to the standard form, an `IconDefinition` or a string like 'account-book-fill` (with a theme suffixed).
     * If namespace is specified, ignore theme because it meaningless for users' icons.
     * @protected
     * @param {?} type
     * @param {?} theme
     * @return {?}
     */
    _parseIconType(type, theme) {
        if (isIconDefinition(type)) {
            return type;
        }
        else {
            const [name, namespace] = getNameAndNamespace(type);
            if (namespace) {
                return type;
            }
            if (alreadyHasAThemeSuffix(name)) {
                if (!!theme) {
                    warn(`'type' ${name} already gets a theme inside so 'theme' ${theme} would be ignored`);
                }
                return name;
            }
            else {
                return withSuffix(name, theme || this._iconService.defaultTheme);
            }
        }
    }
    /**
     * @protected
     * @param {?} svg
     * @return {?}
     */
    _setSVGElement(svg) {
        this._clearSVGElement();
        this._renderer.appendChild(this._elementRef.nativeElement, svg);
    }
    /**
     * @protected
     * @return {?}
     */
    _clearSVGElement() {
        /** @type {?} */
        const el = this._elementRef.nativeElement;
        /** @type {?} */
        const children = el.childNodes;
        /** @type {?} */
        const length = children.length;
        for (let i = length - 1; i >= 0; i--) {
            /** @type {?} */
            const child = (/** @type {?} */ (children[i]));
            if (child.tagName.toLowerCase() === 'svg') {
                this._renderer.removeChild(el, child);
            }
        }
    }
}
IconDirective.decorators = [
    { type: Directive, args: [{
                selector: '[antIcon]'
            },] }
];
/** @nocollapse */
IconDirective.ctorParameters = () => [
    { type: IconService },
    { type: ElementRef },
    { type: Renderer2 }
];
IconDirective.propDecorators = {
    type: [{ type: Input }],
    theme: [{ type: Input }],
    twoToneColor: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    IconDirective.prototype.type;
    /** @type {?} */
    IconDirective.prototype.theme;
    /** @type {?} */
    IconDirective.prototype.twoToneColor;
    /**
     * @type {?}
     * @protected
     */
    IconDirective.prototype._iconService;
    /**
     * @type {?}
     * @protected
     */
    IconDirective.prototype._elementRef;
    /**
     * @type {?}
     * @protected
     */
    IconDirective.prototype._renderer;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaWNvbi5kaXJlY3RpdmUuanMiLCJzb3VyY2VSb290Ijoibmc6Ly9AYW50LWRlc2lnbi9pY29ucy1hbmd1bGFyLyIsInNvdXJjZXMiOlsiY29tcG9uZW50L2ljb24uZGlyZWN0aXZlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7QUFBQSxPQUFPLEVBQ0wsU0FBUyxFQUNULFVBQVUsRUFDVixLQUFLLEVBRUwsU0FBUyxFQUVWLE1BQU0sZUFBZSxDQUFDO0FBRXZCLE9BQU8sRUFBRSxzQkFBc0IsRUFBRSxtQkFBbUIsRUFBRSxnQkFBZ0IsRUFBRSxJQUFJLEVBQUUsVUFBVSxFQUFFLE1BQU0sVUFBVSxDQUFDO0FBQzNHLE9BQU8sRUFBRSxXQUFXLEVBQUUsTUFBTSxnQkFBZ0IsQ0FBQztBQUs3QyxNQUFNLE9BQU8sYUFBYTs7Ozs7O0lBS3hCLFlBQXNCLFlBQXlCLEVBQVksV0FBdUIsRUFBWSxTQUFvQjtRQUE1RixpQkFBWSxHQUFaLFlBQVksQ0FBYTtRQUFZLGdCQUFXLEdBQVgsV0FBVyxDQUFZO1FBQVksY0FBUyxHQUFULFNBQVMsQ0FBVztJQUFHLENBQUM7Ozs7O0lBRXRILFdBQVcsQ0FBQyxPQUFzQjtRQUNoQyxJQUFJLE9BQU8sQ0FBQyxJQUFJLElBQUksT0FBTyxDQUFDLEtBQUssSUFBSSxPQUFPLENBQUMsWUFBWSxFQUFFO1lBQ3pELElBQUksQ0FBQyxXQUFXLEVBQUUsQ0FBQztTQUNwQjtJQUNILENBQUM7Ozs7OztJQUtTLFdBQVc7UUFDbkIsT0FBTyxJQUFJLE9BQU87Ozs7UUFBb0IsT0FBTyxDQUFDLEVBQUU7WUFDOUMsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUU7Z0JBQ2QsSUFBSSxDQUFDLGdCQUFnQixFQUFFLENBQUM7Z0JBQ3hCLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQzthQUNmO2lCQUFNO2dCQUNMLElBQUksQ0FBQyxZQUFZLENBQUMsa0JBQWtCLENBQ2xDLElBQUksQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLEVBQzFDLElBQUksQ0FBQyxZQUFZLENBQ2xCLENBQUMsU0FBUzs7OztnQkFBQyxHQUFHLENBQUMsRUFBRTtvQkFDaEIsSUFBSSxDQUFDLGNBQWMsQ0FBQyxHQUFHLENBQUMsQ0FBQztvQkFDekIsT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUFDO2dCQUNmLENBQUMsRUFBQyxDQUFDO2FBQ0o7UUFDSCxDQUFDLEVBQUMsQ0FBQztJQUNMLENBQUM7Ozs7Ozs7OztJQVFTLGNBQWMsQ0FBQyxJQUE2QixFQUFFLEtBQWdCO1FBQ3RFLElBQUksZ0JBQWdCLENBQUMsSUFBSSxDQUFDLEVBQUU7WUFDMUIsT0FBTyxJQUFJLENBQUM7U0FDYjthQUFNO2tCQUNDLENBQUUsSUFBSSxFQUFFLFNBQVMsQ0FBRSxHQUFHLG1CQUFtQixDQUFDLElBQUksQ0FBQztZQUNyRCxJQUFJLFNBQVMsRUFBRTtnQkFDYixPQUFPLElBQUksQ0FBQzthQUNiO1lBQ0QsSUFBSSxzQkFBc0IsQ0FBQyxJQUFJLENBQUMsRUFBRTtnQkFDaEMsSUFBSSxDQUFDLENBQUMsS0FBSyxFQUFFO29CQUNYLElBQUksQ0FBQyxVQUFVLElBQUksMkNBQTJDLEtBQUssbUJBQW1CLENBQUMsQ0FBQztpQkFDekY7Z0JBQ0QsT0FBTyxJQUFJLENBQUM7YUFDYjtpQkFBTTtnQkFDTCxPQUFPLFVBQVUsQ0FBQyxJQUFJLEVBQUUsS0FBSyxJQUFJLElBQUksQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLENBQUM7YUFDbEU7U0FDRjtJQUNILENBQUM7Ozs7OztJQUVTLGNBQWMsQ0FBQyxHQUFlO1FBQ3RDLElBQUksQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDO1FBQ3hCLElBQUksQ0FBQyxTQUFTLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsYUFBYSxFQUFFLEdBQUcsQ0FBQyxDQUFDO0lBQ2xFLENBQUM7Ozs7O0lBRVMsZ0JBQWdCOztjQUNsQixFQUFFLEdBQWdCLElBQUksQ0FBQyxXQUFXLENBQUMsYUFBYTs7Y0FDaEQsUUFBUSxHQUFHLEVBQUUsQ0FBQyxVQUFVOztjQUN4QixNQUFNLEdBQUcsUUFBUSxDQUFDLE1BQU07UUFDOUIsS0FBSyxJQUFJLENBQUMsR0FBRyxNQUFNLEdBQUcsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUU7O2tCQUM5QixLQUFLLEdBQUcsbUJBQUEsUUFBUSxDQUFFLENBQUMsQ0FBRSxFQUFlO1lBQzFDLElBQUksS0FBSyxDQUFDLE9BQU8sQ0FBQyxXQUFXLEVBQUUsS0FBSyxLQUFLLEVBQUU7Z0JBQ3pDLElBQUksQ0FBQyxTQUFTLENBQUMsV0FBVyxDQUFDLEVBQUUsRUFBRSxLQUFLLENBQUMsQ0FBQzthQUN2QztTQUNGO0lBQ0gsQ0FBQzs7O1lBNUVGLFNBQVMsU0FBQztnQkFDVCxRQUFRLEVBQUUsV0FBVzthQUN0Qjs7OztZQUpRLFdBQVc7WUFSbEIsVUFBVTtZQUdWLFNBQVM7OzttQkFXUixLQUFLO29CQUNMLEtBQUs7MkJBQ0wsS0FBSzs7OztJQUZOLDZCQUF1Qzs7SUFDdkMsOEJBQTBCOztJQUMxQixxQ0FBOEI7Ozs7O0lBRWxCLHFDQUFtQzs7Ozs7SUFBRSxvQ0FBaUM7Ozs7O0lBQUUsa0NBQThCIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtcbiAgRGlyZWN0aXZlLFxuICBFbGVtZW50UmVmLFxuICBJbnB1dCxcbiAgT25DaGFuZ2VzLFxuICBSZW5kZXJlcjIsXG4gIFNpbXBsZUNoYW5nZXNcbn0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgeyBJY29uRGVmaW5pdGlvbiwgVGhlbWVUeXBlIH0gZnJvbSAnLi4vdHlwZXMnO1xuaW1wb3J0IHsgYWxyZWFkeUhhc0FUaGVtZVN1ZmZpeCwgZ2V0TmFtZUFuZE5hbWVzcGFjZSwgaXNJY29uRGVmaW5pdGlvbiwgd2Fybiwgd2l0aFN1ZmZpeCB9IGZyb20gJy4uL3V0aWxzJztcbmltcG9ydCB7IEljb25TZXJ2aWNlIH0gZnJvbSAnLi9pY29uLnNlcnZpY2UnO1xuXG5ARGlyZWN0aXZlKHtcbiAgc2VsZWN0b3I6ICdbYW50SWNvbl0nXG59KVxuZXhwb3J0IGNsYXNzIEljb25EaXJlY3RpdmUgaW1wbGVtZW50cyBPbkNoYW5nZXMge1xuICBASW5wdXQoKSB0eXBlOiBzdHJpbmcgfCBJY29uRGVmaW5pdGlvbjtcbiAgQElucHV0KCkgdGhlbWU6IFRoZW1lVHlwZTtcbiAgQElucHV0KCkgdHdvVG9uZUNvbG9yOiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3IocHJvdGVjdGVkIF9pY29uU2VydmljZTogSWNvblNlcnZpY2UsIHByb3RlY3RlZCBfZWxlbWVudFJlZjogRWxlbWVudFJlZiwgcHJvdGVjdGVkIF9yZW5kZXJlcjogUmVuZGVyZXIyKSB7fVxuXG4gIG5nT25DaGFuZ2VzKGNoYW5nZXM6IFNpbXBsZUNoYW5nZXMpOiB2b2lkIHtcbiAgICBpZiAoY2hhbmdlcy50eXBlIHx8IGNoYW5nZXMudGhlbWUgfHwgY2hhbmdlcy50d29Ub25lQ29sb3IpIHtcbiAgICAgIHRoaXMuX2NoYW5nZUljb24oKTtcbiAgICB9XG4gIH1cblxuICAvKipcbiAgICogUmVuZGVyIGEgbmV3IGljb24gaW4gdGhlIGN1cnJlbnQgZWxlbWVudC4gUmVtb3ZlIHRoZSBpY29uIHdoZW4gYHR5cGVgIGlzIGZhbHN5LlxuICAgKi9cbiAgcHJvdGVjdGVkIF9jaGFuZ2VJY29uKCk6IFByb21pc2U8U1ZHRWxlbWVudCB8IG51bGw+IHtcbiAgICByZXR1cm4gbmV3IFByb21pc2U8U1ZHRWxlbWVudCB8IG51bGw+KHJlc29sdmUgPT4ge1xuICAgICAgaWYgKCF0aGlzLnR5cGUpIHtcbiAgICAgICAgdGhpcy5fY2xlYXJTVkdFbGVtZW50KCk7XG4gICAgICAgIHJlc29sdmUobnVsbCk7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICB0aGlzLl9pY29uU2VydmljZS5nZXRSZW5kZXJlZENvbnRlbnQoXG4gICAgICAgICAgdGhpcy5fcGFyc2VJY29uVHlwZSh0aGlzLnR5cGUsIHRoaXMudGhlbWUpLFxuICAgICAgICAgIHRoaXMudHdvVG9uZUNvbG9yXG4gICAgICAgICkuc3Vic2NyaWJlKHN2ZyA9PiB7XG4gICAgICAgICAgdGhpcy5fc2V0U1ZHRWxlbWVudChzdmcpO1xuICAgICAgICAgIHJlc29sdmUoc3ZnKTtcbiAgICAgICAgfSk7XG4gICAgICB9XG4gICAgfSk7XG4gIH1cblxuICAvKipcbiAgICogUGFyc2UgYSBpY29uIHRvIHRoZSBzdGFuZGFyZCBmb3JtLCBhbiBgSWNvbkRlZmluaXRpb25gIG9yIGEgc3RyaW5nIGxpa2UgJ2FjY291bnQtYm9vay1maWxsYCAod2l0aCBhIHRoZW1lIHN1ZmZpeGVkKS5cbiAgICogSWYgbmFtZXNwYWNlIGlzIHNwZWNpZmllZCwgaWdub3JlIHRoZW1lIGJlY2F1c2UgaXQgbWVhbmluZ2xlc3MgZm9yIHVzZXJzJyBpY29ucy5cbiAgICogQHBhcmFtIHR5cGVcbiAgICogQHBhcmFtIHRoZW1lXG4gICAqL1xuICBwcm90ZWN0ZWQgX3BhcnNlSWNvblR5cGUodHlwZTogc3RyaW5nIHwgSWNvbkRlZmluaXRpb24sIHRoZW1lOiBUaGVtZVR5cGUpOiBJY29uRGVmaW5pdGlvbiB8IHN0cmluZyB7XG4gICAgaWYgKGlzSWNvbkRlZmluaXRpb24odHlwZSkpIHtcbiAgICAgIHJldHVybiB0eXBlO1xuICAgIH0gZWxzZSB7XG4gICAgICBjb25zdCBbIG5hbWUsIG5hbWVzcGFjZSBdID0gZ2V0TmFtZUFuZE5hbWVzcGFjZSh0eXBlKTtcbiAgICAgIGlmIChuYW1lc3BhY2UpIHtcbiAgICAgICAgcmV0dXJuIHR5cGU7XG4gICAgICB9XG4gICAgICBpZiAoYWxyZWFkeUhhc0FUaGVtZVN1ZmZpeChuYW1lKSkge1xuICAgICAgICBpZiAoISF0aGVtZSkge1xuICAgICAgICAgIHdhcm4oYCd0eXBlJyAke25hbWV9IGFscmVhZHkgZ2V0cyBhIHRoZW1lIGluc2lkZSBzbyAndGhlbWUnICR7dGhlbWV9IHdvdWxkIGJlIGlnbm9yZWRgKTtcbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gbmFtZTtcbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIHJldHVybiB3aXRoU3VmZml4KG5hbWUsIHRoZW1lIHx8IHRoaXMuX2ljb25TZXJ2aWNlLmRlZmF1bHRUaGVtZSk7XG4gICAgICB9XG4gICAgfVxuICB9XG5cbiAgcHJvdGVjdGVkIF9zZXRTVkdFbGVtZW50KHN2ZzogU1ZHRWxlbWVudCk6IHZvaWQge1xuICAgIHRoaXMuX2NsZWFyU1ZHRWxlbWVudCgpO1xuICAgIHRoaXMuX3JlbmRlcmVyLmFwcGVuZENoaWxkKHRoaXMuX2VsZW1lbnRSZWYubmF0aXZlRWxlbWVudCwgc3ZnKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBfY2xlYXJTVkdFbGVtZW50KCk6IHZvaWQge1xuICAgIGNvbnN0IGVsOiBIVE1MRWxlbWVudCA9IHRoaXMuX2VsZW1lbnRSZWYubmF0aXZlRWxlbWVudDtcbiAgICBjb25zdCBjaGlsZHJlbiA9IGVsLmNoaWxkTm9kZXM7XG4gICAgY29uc3QgbGVuZ3RoID0gY2hpbGRyZW4ubGVuZ3RoO1xuICAgIGZvciAobGV0IGkgPSBsZW5ndGggLSAxOyBpID49IDA7IGktLSkge1xuICAgICAgY29uc3QgY2hpbGQgPSBjaGlsZHJlblsgaSBdIGFzIEhUTUxFbGVtZW50O1xuICAgICAgaWYgKGNoaWxkLnRhZ05hbWUudG9Mb3dlckNhc2UoKSA9PT0gJ3N2ZycpIHtcbiAgICAgICAgdGhpcy5fcmVuZGVyZXIucmVtb3ZlQ2hpbGQoZWwsIGNoaWxkKTtcbiAgICAgIH1cbiAgICB9XG4gIH1cbn1cbiJdfQ==