/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { isDevMode } from '@angular/core';
import { generate as generateColor } from '@ant-design/colors';
/** @type {?} */
export var ANT_ICON_ANGULAR_CONSOLE_PREFIX = '[@ant-design/icons-angular]:';
/**
 * @param {?} message
 * @return {?}
 */
export function error(message) {
    console.error(ANT_ICON_ANGULAR_CONSOLE_PREFIX + " " + message + ".");
}
/**
 * @param {?} message
 * @return {?}
 */
export function warn(message) {
    if (isDevMode()) {
        console.warn(ANT_ICON_ANGULAR_CONSOLE_PREFIX + " " + message + ".");
    }
}
/**
 * @param {?} primaryColor
 * @return {?}
 */
export function getSecondaryColor(primaryColor) {
    return generateColor(primaryColor)[0];
}
/**
 * @param {?} name
 * @param {?} theme
 * @return {?}
 */
export function withSuffix(name, theme) {
    switch (theme) {
        case 'fill': return name + "-fill";
        case 'outline': return name + "-o";
        case 'twotone': return name + "-twotone";
        case undefined: return name;
        default: throw new Error(ANT_ICON_ANGULAR_CONSOLE_PREFIX + "Theme \"" + theme + "\" is not a recognized theme!");
    }
}
/**
 * @param {?} name
 * @param {?} theme
 * @param {?} pri
 * @param {?} sec
 * @return {?}
 */
export function withSuffixAndColor(name, theme, pri, sec) {
    return withSuffix(name, theme) + "-" + pri + "-" + sec;
}
/**
 * @param {?} abbr
 * @return {?}
 */
export function mapAbbrToTheme(abbr) {
    return abbr === 'o' ? 'outline' : (/** @type {?} */ (abbr));
}
/**
 * @param {?} name
 * @return {?}
 */
export function alreadyHasAThemeSuffix(name) {
    return name.endsWith('-fill') || name.endsWith('-o') || name.endsWith('-twotone');
}
/**
 * @param {?} target
 * @return {?}
 */
export function isIconDefinition(target) {
    return (typeof target === 'object' &&
        typeof target.name === 'string' &&
        (typeof target.theme === 'string' || target.theme === undefined) &&
        typeof target.icon === 'string');
}
/**
 * Get an `IconDefinition` object from abbreviation type, like `account-book-fill`.
 * @param {?} str
 * @return {?}
 */
export function getIconDefinitionFromAbbr(str) {
    /** @type {?} */
    var arr = str.split('-');
    /** @type {?} */
    var theme = mapAbbrToTheme(arr.splice(arr.length - 1, 1)[0]);
    /** @type {?} */
    var name = arr.join('-');
    return (/** @type {?} */ ({
        name: name,
        theme: theme,
        icon: ''
    }));
}
/**
 * @param {?} svg
 * @return {?}
 */
export function cloneSVG(svg) {
    return (/** @type {?} */ (svg.cloneNode(true)));
}
/**
 * Parse inline SVG string and replace colors with placeholders. For twotone icons only.
 * @param {?} raw
 * @return {?}
 */
export function replaceFillColor(raw) {
    return raw
        .replace(/['"]#333['"]/g, '"primaryColor"')
        .replace(/['"]#E6E6E6['"]/g, '"secondaryColor"')
        .replace(/['"]#D9D9D9['"]/g, '"secondaryColor"')
        .replace(/['"]#D8D8D8['"]/g, '"secondaryColor"');
}
/**
 * Split a name with namespace in it into a tuple like [ name, namespace ].
 * @param {?} type
 * @return {?}
 */
export function getNameAndNamespace(type) {
    /** @type {?} */
    var split = type.split(':');
    switch (split.length) {
        case 1: return [type, ''];
        case 2: return [split[1], split[0]];
        default: throw new Error(ANT_ICON_ANGULAR_CONSOLE_PREFIX + "The icon type " + type + " is not valid!");
    }
}
/**
 * @param {?} type
 * @return {?}
 */
export function hasNamespace(type) {
    return getNameAndNamespace(type)[1] !== '';
}
//# sourceMappingURL=data:application/json;base64,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