/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { AfterContentInit, ElementRef, OnChanges, OnDestroy, OnInit, QueryList, Renderer2, SimpleChanges } from '@angular/core';
import { Router, RouterLink, RouterLinkWithHref } from '@angular/router';
import { NzMenuBaseService, NzUpdateHostClassService } from 'ng-zorro-antd/core';
import { Subject } from 'rxjs';
import { NzSubmenuService } from './nz-submenu.service';
import * as ɵngcc0 from '@angular/core';
export declare class NzMenuItemDirective implements OnInit, OnChanges, OnDestroy, AfterContentInit {
    private nzUpdateHostClassService;
    private nzMenuService;
    private nzSubmenuService;
    private renderer;
    private elementRef;
    private routerLink?;
    private routerLinkWithHref?;
    private router?;
    private el;
    private destroy$;
    private originalPadding;
    selected$: Subject<boolean>;
    nzDisabled: boolean;
    nzSelected: boolean;
    nzPaddingLeft: number;
    nzMatchRouterExact: boolean;
    nzMatchRouter: boolean;
    listOfRouterLink: QueryList<RouterLink>;
    listOfRouterLinkWithHref: QueryList<RouterLinkWithHref>;
    /** clear all item selected status except this */
    clickMenuItem(e: MouseEvent): void;
    setClassMap(): void;
    setSelectedState(value: boolean): void;
    private updateRouterActive;
    private hasActiveLinks;
    private isLinkActive;
    constructor(nzUpdateHostClassService: NzUpdateHostClassService, nzMenuService: NzMenuBaseService, nzSubmenuService: NzSubmenuService, renderer: Renderer2, elementRef: ElementRef, routerLink?: RouterLink | undefined, routerLinkWithHref?: RouterLinkWithHref | undefined, router?: Router | undefined);
    ngOnInit(): void;
    ngAfterContentInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngOnDestroy(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzMenuItemDirective>;
    static ɵdir: ɵngcc0.ɵɵDirectiveDefWithMeta<NzMenuItemDirective, "[nz-menu-item]", ["nzMenuItem"], {
    "nzDisabled": "nzDisabled";
    "nzSelected": "nzSelected";
    "nzMatchRouterExact": "nzMatchRouterExact";
    "nzMatchRouter": "nzMatchRouter";
    "nzPaddingLeft": "nzPaddingLeft";
}, {}, ["listOfRouterLink", "listOfRouterLinkWithHref"]>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibnotbWVudS1pdGVtLmRpcmVjdGl2ZS5kLnRzIiwic291cmNlcyI6WyJuei1tZW51LWl0ZW0uZGlyZWN0aXZlLmQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Ozs7Ozs7OztBQUNBIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEFsaWJhYmEuY29tIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogVXNlIG9mIHRoaXMgc291cmNlIGNvZGUgaXMgZ292ZXJuZWQgYnkgYW4gTUlULXN0eWxlIGxpY2Vuc2UgdGhhdCBjYW4gYmVcbiAqIGZvdW5kIGluIHRoZSBMSUNFTlNFIGZpbGUgYXQgaHR0cHM6Ly9naXRodWIuY29tL05HLVpPUlJPL25nLXpvcnJvLWFudGQvYmxvYi9tYXN0ZXIvTElDRU5TRVxuICovXG5pbXBvcnQgeyBBZnRlckNvbnRlbnRJbml0LCBFbGVtZW50UmVmLCBPbkNoYW5nZXMsIE9uRGVzdHJveSwgT25Jbml0LCBRdWVyeUxpc3QsIFJlbmRlcmVyMiwgU2ltcGxlQ2hhbmdlcyB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgUm91dGVyLCBSb3V0ZXJMaW5rLCBSb3V0ZXJMaW5rV2l0aEhyZWYgfSBmcm9tICdAYW5ndWxhci9yb3V0ZXInO1xuaW1wb3J0IHsgTnpNZW51QmFzZVNlcnZpY2UsIE56VXBkYXRlSG9zdENsYXNzU2VydmljZSB9IGZyb20gJ25nLXpvcnJvLWFudGQvY29yZSc7XG5pbXBvcnQgeyBTdWJqZWN0IH0gZnJvbSAncnhqcyc7XG5pbXBvcnQgeyBOelN1Ym1lbnVTZXJ2aWNlIH0gZnJvbSAnLi9uei1zdWJtZW51LnNlcnZpY2UnO1xuZXhwb3J0IGRlY2xhcmUgY2xhc3MgTnpNZW51SXRlbURpcmVjdGl2ZSBpbXBsZW1lbnRzIE9uSW5pdCwgT25DaGFuZ2VzLCBPbkRlc3Ryb3ksIEFmdGVyQ29udGVudEluaXQge1xuICAgIHByaXZhdGUgbnpVcGRhdGVIb3N0Q2xhc3NTZXJ2aWNlO1xuICAgIHByaXZhdGUgbnpNZW51U2VydmljZTtcbiAgICBwcml2YXRlIG56U3VibWVudVNlcnZpY2U7XG4gICAgcHJpdmF0ZSByZW5kZXJlcjtcbiAgICBwcml2YXRlIGVsZW1lbnRSZWY7XG4gICAgcHJpdmF0ZSByb3V0ZXJMaW5rPztcbiAgICBwcml2YXRlIHJvdXRlckxpbmtXaXRoSHJlZj87XG4gICAgcHJpdmF0ZSByb3V0ZXI/O1xuICAgIHByaXZhdGUgZWw7XG4gICAgcHJpdmF0ZSBkZXN0cm95JDtcbiAgICBwcml2YXRlIG9yaWdpbmFsUGFkZGluZztcbiAgICBzZWxlY3RlZCQ6IFN1YmplY3Q8Ym9vbGVhbj47XG4gICAgbnpEaXNhYmxlZDogYm9vbGVhbjtcbiAgICBuelNlbGVjdGVkOiBib29sZWFuO1xuICAgIG56UGFkZGluZ0xlZnQ6IG51bWJlcjtcbiAgICBuek1hdGNoUm91dGVyRXhhY3Q6IGJvb2xlYW47XG4gICAgbnpNYXRjaFJvdXRlcjogYm9vbGVhbjtcbiAgICBsaXN0T2ZSb3V0ZXJMaW5rOiBRdWVyeUxpc3Q8Um91dGVyTGluaz47XG4gICAgbGlzdE9mUm91dGVyTGlua1dpdGhIcmVmOiBRdWVyeUxpc3Q8Um91dGVyTGlua1dpdGhIcmVmPjtcbiAgICAvKiogY2xlYXIgYWxsIGl0ZW0gc2VsZWN0ZWQgc3RhdHVzIGV4Y2VwdCB0aGlzICovXG4gICAgY2xpY2tNZW51SXRlbShlOiBNb3VzZUV2ZW50KTogdm9pZDtcbiAgICBzZXRDbGFzc01hcCgpOiB2b2lkO1xuICAgIHNldFNlbGVjdGVkU3RhdGUodmFsdWU6IGJvb2xlYW4pOiB2b2lkO1xuICAgIHByaXZhdGUgdXBkYXRlUm91dGVyQWN0aXZlO1xuICAgIHByaXZhdGUgaGFzQWN0aXZlTGlua3M7XG4gICAgcHJpdmF0ZSBpc0xpbmtBY3RpdmU7XG4gICAgY29uc3RydWN0b3IobnpVcGRhdGVIb3N0Q2xhc3NTZXJ2aWNlOiBOelVwZGF0ZUhvc3RDbGFzc1NlcnZpY2UsIG56TWVudVNlcnZpY2U6IE56TWVudUJhc2VTZXJ2aWNlLCBuelN1Ym1lbnVTZXJ2aWNlOiBOelN1Ym1lbnVTZXJ2aWNlLCByZW5kZXJlcjogUmVuZGVyZXIyLCBlbGVtZW50UmVmOiBFbGVtZW50UmVmLCByb3V0ZXJMaW5rPzogUm91dGVyTGluayB8IHVuZGVmaW5lZCwgcm91dGVyTGlua1dpdGhIcmVmPzogUm91dGVyTGlua1dpdGhIcmVmIHwgdW5kZWZpbmVkLCByb3V0ZXI/OiBSb3V0ZXIgfCB1bmRlZmluZWQpO1xuICAgIG5nT25Jbml0KCk6IHZvaWQ7XG4gICAgbmdBZnRlckNvbnRlbnRJbml0KCk6IHZvaWQ7XG4gICAgbmdPbkNoYW5nZXMoY2hhbmdlczogU2ltcGxlQ2hhbmdlcyk6IHZvaWQ7XG4gICAgbmdPbkRlc3Ryb3koKTogdm9pZDtcbn1cbiJdfQ==