/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ChangeDetectorRef, DebugElement, ElementRef, OnChanges, OnDestroy, OnInit, SimpleChanges, TemplateRef } from '@angular/core';
import { ControlValueAccessor } from '@angular/forms';
import { NzUpdateHostClassService as UpdateCls } from 'ng-zorro-antd/core';
import { NzTimeValueAccessorDirective } from './nz-time-value-accessor.directive';
import { TimeHolder } from './time-holder';
import * as ɵngcc0 from '@angular/core';
export declare type NzTimePickerUnit = 'hour' | 'minute' | 'second' | '12-hour';
export declare class NzTimePickerPanelComponent implements ControlValueAccessor, OnInit, OnDestroy, OnChanges {
    private element;
    private updateCls;
    private cdr;
    private _nzHourStep;
    private _nzMinuteStep;
    private _nzSecondStep;
    private unsubscribe$;
    private onChange;
    private onTouch;
    private _format;
    private _disabledHours;
    private _disabledMinutes;
    private _disabledSeconds;
    private _allowEmpty;
    prefixCls: string;
    time: TimeHolder;
    hourEnabled: boolean;
    minuteEnabled: boolean;
    secondEnabled: boolean;
    enabledColumns: number;
    hourRange: ReadonlyArray<{
        index: number;
        disabled: boolean;
    }>;
    minuteRange: ReadonlyArray<{
        index: number;
        disabled: boolean;
    }>;
    secondRange: ReadonlyArray<{
        index: number;
        disabled: boolean;
    }>;
    use12HoursRange: ReadonlyArray<{
        index: number;
        value: string;
    }>;
    nzTimeValueAccessorDirective: NzTimeValueAccessorDirective;
    hourListElement: DebugElement;
    minuteListElement: DebugElement;
    secondListElement: DebugElement;
    use12HoursListElement: DebugElement;
    nzInDatePicker: boolean;
    nzAddOn: TemplateRef<void>;
    nzHideDisabledOptions: boolean;
    nzClearText: string;
    nzPlaceHolder: string;
    nzUse12Hours: boolean;
    opened: boolean;
    nzDefaultOpenValue: Date;
    nzAllowEmpty: boolean;
    nzDisabledHours: () => number[];
    nzDisabledMinutes: (hour: number) => number[];
    nzDisabledSeconds: (hour: number, minute: number) => number[];
    format: string;
    nzHourStep: number;
    nzMinuteStep: number;
    nzSecondStep: number;
    selectInputRange(): void;
    buildHours(): void;
    buildMinutes(): void;
    buildSeconds(): void;
    build12Hours(): void;
    buildTimes(): void;
    selectHour(hour: {
        index: number;
        disabled: boolean;
    }): void;
    selectMinute(minute: {
        index: number;
        disabled: boolean;
    }): void;
    selectSecond(second: {
        index: number;
        disabled: boolean;
    }): void;
    select12Hours(value: {
        index: number;
        value: string;
    }): void;
    scrollToSelected(instance: HTMLElement, index: number, duration: number | undefined, unit: NzTimePickerUnit): void;
    translateIndex(index: number, unit: NzTimePickerUnit): number;
    scrollTo(element: HTMLElement, to: number, duration: number): void;
    calcIndex(array: number[], index: number): number;
    protected changed(): void;
    protected touched(): void;
    private setClassMap;
    isSelectedHour(hour: {
        index: number;
        disabled: boolean;
    }): boolean;
    isSelectedMinute(minute: {
        index: number;
        disabled: boolean;
    }): boolean;
    isSelectedSecond(second: {
        index: number;
        disabled: boolean;
    }): boolean;
    isSelected12Hours(value: {
        index: number;
        value: string;
    }): boolean;
    initPosition(): void;
    constructor(element: ElementRef, updateCls: UpdateCls, cdr: ChangeDetectorRef);
    ngOnInit(): void;
    ngOnDestroy(): void;
    ngOnChanges(changes: SimpleChanges): void;
    writeValue(value: Date): void;
    registerOnChange(fn: (value: Date) => void): void;
    registerOnTouched(fn: () => void): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzTimePickerPanelComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzTimePickerPanelComponent, "nz-time-picker-panel", ["nzTimePickerPanel"], {
    "nzInDatePicker": "nzInDatePicker";
    "nzHideDisabledOptions": "nzHideDisabledOptions";
    "nzUse12Hours": "nzUse12Hours";
    "opened": "opened";
    "nzDefaultOpenValue": "nzDefaultOpenValue";
    "nzAllowEmpty": "nzAllowEmpty";
    "nzDisabledHours": "nzDisabledHours";
    "nzDisabledMinutes": "nzDisabledMinutes";
    "nzDisabledSeconds": "nzDisabledSeconds";
    "format": "format";
    "nzHourStep": "nzHourStep";
    "nzMinuteStep": "nzMinuteStep";
    "nzSecondStep": "nzSecondStep";
    "nzAddOn": "nzAddOn";
    "nzClearText": "nzClearText";
    "nzPlaceHolder": "nzPlaceHolder";
}, {}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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