/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ChangeDetectorRef, ElementRef, EventEmitter, OnChanges, OnDestroy, OnInit, Renderer2, SimpleChanges, TemplateRef } from '@angular/core';
import { Observable } from 'rxjs';
import { NzUpdateHostClassService } from 'ng-zorro-antd/core';
import { NzI18nService } from 'ng-zorro-antd/i18n';
import { TransferCanMove, TransferChange, TransferDirection, TransferItem, TransferSearchChange, TransferSelectChange } from './interface';
import * as ɵngcc0 from '@angular/core';
export declare class NzTransferComponent implements OnInit, OnChanges, OnDestroy {
    private cdr;
    private i18n;
    private nzUpdateHostClassService;
    private elementRef;
    private unsubscribe$;
    private lists;
    locale: any;
    leftFilter: string;
    rightFilter: string;
    nzDisabled: boolean;
    nzDataSource: TransferItem[];
    nzTitles: string[];
    nzOperations: string[];
    nzListStyle: object;
    nzShowSelectAll: boolean;
    nzItemUnit: string;
    nzItemsUnit: string;
    nzCanMove: (arg: TransferCanMove) => Observable<TransferItem[]>;
    nzRenderList: Array<TemplateRef<void> | null>;
    nzRender: TemplateRef<void>;
    nzFooter: TemplateRef<void>;
    nzShowSearch: boolean;
    nzFilterOption: (inputValue: string, item: TransferItem) => boolean;
    nzSearchPlaceholder: string;
    nzNotFoundContent: string;
    readonly nzChange: EventEmitter<TransferChange>;
    readonly nzSearchChange: EventEmitter<TransferSearchChange>;
    readonly nzSelectChange: EventEmitter<TransferSelectChange>;
    leftDataSource: TransferItem[];
    rightDataSource: TransferItem[];
    private splitDataSource;
    private getCheckedData;
    handleLeftSelectAll: (checked: boolean) => void;
    handleRightSelectAll: (checked: boolean) => void;
    handleLeftSelect: (item: TransferItem) => void;
    handleRightSelect: (item: TransferItem) => void;
    handleSelect(direction: TransferDirection, checked: boolean, item?: TransferItem): void;
    handleFilterChange(ret: {
        direction: TransferDirection;
        value: string;
    }): void;
    leftActive: boolean;
    rightActive: boolean;
    private updateOperationStatus;
    moveToLeft: () => void;
    moveToRight: () => void;
    moveTo(direction: TransferDirection): void;
    private truthMoveTo;
    constructor(cdr: ChangeDetectorRef, i18n: NzI18nService, nzUpdateHostClassService: NzUpdateHostClassService, elementRef: ElementRef, renderer: Renderer2);
    private setClassMap;
    private markForCheckAllList;
    ngOnInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngOnDestroy(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzTransferComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzTransferComponent, "nz-transfer", ["nzTransfer"], {
    "nzDisabled": "nzDisabled";
    "nzDataSource": "nzDataSource";
    "nzTitles": "nzTitles";
    "nzOperations": "nzOperations";
    "nzShowSelectAll": "nzShowSelectAll";
    "nzCanMove": "nzCanMove";
    "nzRenderList": "nzRenderList";
    "nzShowSearch": "nzShowSearch";
    "nzListStyle": "nzListStyle";
    "nzItemUnit": "nzItemUnit";
    "nzItemsUnit": "nzItemsUnit";
    "nzRender": "nzRender";
    "nzFooter": "nzFooter";
    "nzFilterOption": "nzFilterOption";
    "nzSearchPlaceholder": "nzSearchPlaceholder";
    "nzNotFoundContent": "nzNotFoundContent";
}, {
    "nzChange": "nzChange";
    "nzSearchChange": "nzSearchChange";
    "nzSelectChange": "nzSelectChange";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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