/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ChangeDetectorRef, EventEmitter, OnChanges, OnDestroy, OnInit, SimpleChange, SimpleChanges } from '@angular/core';
import { Observable, Subscription } from 'rxjs';
import { NzI18nService } from 'ng-zorro-antd/i18n';
import { ShowUploadListInterface, UploadChangeParam, UploadFile, UploadFilter, UploadListType, UploadType, UploadXHRArgs, ZipButtonOptions } from './interface';
import { NzUploadBtnComponent } from './nz-upload-btn.component';
import { NzUploadListComponent } from './nz-upload-list.component';
import * as ɵngcc0 from '@angular/core';
export declare class NzUploadComponent implements OnInit, OnChanges, OnDestroy {
    private cdr;
    private i18n;
    private i18n$;
    uploadComp: NzUploadBtnComponent;
    listComp: NzUploadListComponent;
    locale: any;
    nzType: UploadType;
    nzLimit: number;
    nzSize: number;
    nzFileType: string;
    nzAccept: string | string[];
    nzAction: string;
    nzDirectory: boolean;
    nzOpenFileDialogOnClick: boolean;
    nzBeforeUpload: (file: UploadFile, fileList: UploadFile[]) => boolean | Observable<boolean>;
    nzCustomRequest: (item: UploadXHRArgs) => Subscription;
    nzData: {} | ((file: UploadFile) => {});
    nzFilter: UploadFilter[];
    nzFileList: UploadFile[];
    nzDisabled: boolean;
    nzHeaders: {} | ((file: UploadFile) => {});
    nzListType: UploadListType;
    nzMultiple: boolean;
    nzName: string;
    private _showUploadList;
    nzShowUploadList: boolean | ShowUploadListInterface;
    nzShowButton: boolean;
    nzWithCredentials: boolean;
    nzRemove: (file: UploadFile) => boolean | Observable<boolean>;
    nzPreview: (file: UploadFile) => void;
    readonly nzChange: EventEmitter<UploadChangeParam>;
    readonly nzFileListChange: EventEmitter<UploadFile[]>;
    _btnOptions: ZipButtonOptions;
    private zipOptions;
    constructor(cdr: ChangeDetectorRef, i18n: NzI18nService);
    private fileToObject;
    private getFileItem;
    private removeFileItem;
    private genErr;
    private onStart;
    private onProgress;
    private onSuccess;
    private onError;
    private dragState;
    fileDrop(e: any): void;
    private detectChangesList;
    onRemove: (file: UploadFile) => void;
    private prefixCls;
    classList: string[];
    private setClassMap;
    ngOnInit(): void;
    ngOnChanges(changes: {
        [P in keyof this]?: SimpleChange;
    } & SimpleChanges): void;
    ngOnDestroy(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzUploadComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzUploadComponent, "nz-upload", ["nzUpload"], {
    "nzType": "nzType";
    "nzLimit": "nzLimit";
    "nzSize": "nzSize";
    "nzDirectory": "nzDirectory";
    "nzOpenFileDialogOnClick": "nzOpenFileDialogOnClick";
    "nzFilter": "nzFilter";
    "nzFileList": "nzFileList";
    "nzDisabled": "nzDisabled";
    "nzListType": "nzListType";
    "nzMultiple": "nzMultiple";
    "nzName": "nzName";
    "nzShowButton": "nzShowButton";
    "nzWithCredentials": "nzWithCredentials";
    "nzShowUploadList": "nzShowUploadList";
    "nzFileType": "nzFileType";
    "nzAccept": "nzAccept";
    "nzAction": "nzAction";
    "nzBeforeUpload": "nzBeforeUpload";
    "nzCustomRequest": "nzCustomRequest";
    "nzData": "nzData";
    "nzHeaders": "nzHeaders";
    "nzRemove": "nzRemove";
    "nzPreview": "nzPreview";
}, {
    "nzChange": "nzChange";
    "nzFileListChange": "nzFileListChange";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibnotdXBsb2FkLmNvbXBvbmVudC5kLnRzIiwic291cmNlcyI6WyJuei11cGxvYWQuY29tcG9uZW50LmQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBQ0EiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgQWxpYmFiYS5jb20gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2dpdGh1Yi5jb20vTkctWk9SUk8vbmctem9ycm8tYW50ZC9ibG9iL21hc3Rlci9MSUNFTlNFXG4gKi9cbmltcG9ydCB7IENoYW5nZURldGVjdG9yUmVmLCBFdmVudEVtaXR0ZXIsIE9uQ2hhbmdlcywgT25EZXN0cm95LCBPbkluaXQsIFNpbXBsZUNoYW5nZSwgU2ltcGxlQ2hhbmdlcyB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgT2JzZXJ2YWJsZSwgU3Vic2NyaXB0aW9uIH0gZnJvbSAncnhqcyc7XG5pbXBvcnQgeyBOekkxOG5TZXJ2aWNlIH0gZnJvbSAnbmctem9ycm8tYW50ZC9pMThuJztcbmltcG9ydCB7IFNob3dVcGxvYWRMaXN0SW50ZXJmYWNlLCBVcGxvYWRDaGFuZ2VQYXJhbSwgVXBsb2FkRmlsZSwgVXBsb2FkRmlsdGVyLCBVcGxvYWRMaXN0VHlwZSwgVXBsb2FkVHlwZSwgVXBsb2FkWEhSQXJncywgWmlwQnV0dG9uT3B0aW9ucyB9IGZyb20gJy4vaW50ZXJmYWNlJztcbmltcG9ydCB7IE56VXBsb2FkQnRuQ29tcG9uZW50IH0gZnJvbSAnLi9uei11cGxvYWQtYnRuLmNvbXBvbmVudCc7XG5pbXBvcnQgeyBOelVwbG9hZExpc3RDb21wb25lbnQgfSBmcm9tICcuL256LXVwbG9hZC1saXN0LmNvbXBvbmVudCc7XG5leHBvcnQgZGVjbGFyZSBjbGFzcyBOelVwbG9hZENvbXBvbmVudCBpbXBsZW1lbnRzIE9uSW5pdCwgT25DaGFuZ2VzLCBPbkRlc3Ryb3kge1xuICAgIHByaXZhdGUgY2RyO1xuICAgIHByaXZhdGUgaTE4bjtcbiAgICBwcml2YXRlIGkxOG4kO1xuICAgIHVwbG9hZENvbXA6IE56VXBsb2FkQnRuQ29tcG9uZW50O1xuICAgIGxpc3RDb21wOiBOelVwbG9hZExpc3RDb21wb25lbnQ7XG4gICAgbG9jYWxlOiBhbnk7XG4gICAgbnpUeXBlOiBVcGxvYWRUeXBlO1xuICAgIG56TGltaXQ6IG51bWJlcjtcbiAgICBuelNpemU6IG51bWJlcjtcbiAgICBuekZpbGVUeXBlOiBzdHJpbmc7XG4gICAgbnpBY2NlcHQ6IHN0cmluZyB8IHN0cmluZ1tdO1xuICAgIG56QWN0aW9uOiBzdHJpbmc7XG4gICAgbnpEaXJlY3Rvcnk6IGJvb2xlYW47XG4gICAgbnpPcGVuRmlsZURpYWxvZ09uQ2xpY2s6IGJvb2xlYW47XG4gICAgbnpCZWZvcmVVcGxvYWQ6IChmaWxlOiBVcGxvYWRGaWxlLCBmaWxlTGlzdDogVXBsb2FkRmlsZVtdKSA9PiBib29sZWFuIHwgT2JzZXJ2YWJsZTxib29sZWFuPjtcbiAgICBuekN1c3RvbVJlcXVlc3Q6IChpdGVtOiBVcGxvYWRYSFJBcmdzKSA9PiBTdWJzY3JpcHRpb247XG4gICAgbnpEYXRhOiB7fSB8ICgoZmlsZTogVXBsb2FkRmlsZSkgPT4ge30pO1xuICAgIG56RmlsdGVyOiBVcGxvYWRGaWx0ZXJbXTtcbiAgICBuekZpbGVMaXN0OiBVcGxvYWRGaWxlW107XG4gICAgbnpEaXNhYmxlZDogYm9vbGVhbjtcbiAgICBuekhlYWRlcnM6IHt9IHwgKChmaWxlOiBVcGxvYWRGaWxlKSA9PiB7fSk7XG4gICAgbnpMaXN0VHlwZTogVXBsb2FkTGlzdFR5cGU7XG4gICAgbnpNdWx0aXBsZTogYm9vbGVhbjtcbiAgICBuek5hbWU6IHN0cmluZztcbiAgICBwcml2YXRlIF9zaG93VXBsb2FkTGlzdDtcbiAgICBuelNob3dVcGxvYWRMaXN0OiBib29sZWFuIHwgU2hvd1VwbG9hZExpc3RJbnRlcmZhY2U7XG4gICAgbnpTaG93QnV0dG9uOiBib29sZWFuO1xuICAgIG56V2l0aENyZWRlbnRpYWxzOiBib29sZWFuO1xuICAgIG56UmVtb3ZlOiAoZmlsZTogVXBsb2FkRmlsZSkgPT4gYm9vbGVhbiB8IE9ic2VydmFibGU8Ym9vbGVhbj47XG4gICAgbnpQcmV2aWV3OiAoZmlsZTogVXBsb2FkRmlsZSkgPT4gdm9pZDtcbiAgICByZWFkb25seSBuekNoYW5nZTogRXZlbnRFbWl0dGVyPFVwbG9hZENoYW5nZVBhcmFtPjtcbiAgICByZWFkb25seSBuekZpbGVMaXN0Q2hhbmdlOiBFdmVudEVtaXR0ZXI8VXBsb2FkRmlsZVtdPjtcbiAgICBfYnRuT3B0aW9uczogWmlwQnV0dG9uT3B0aW9ucztcbiAgICBwcml2YXRlIHppcE9wdGlvbnM7XG4gICAgY29uc3RydWN0b3IoY2RyOiBDaGFuZ2VEZXRlY3RvclJlZiwgaTE4bjogTnpJMThuU2VydmljZSk7XG4gICAgcHJpdmF0ZSBmaWxlVG9PYmplY3Q7XG4gICAgcHJpdmF0ZSBnZXRGaWxlSXRlbTtcbiAgICBwcml2YXRlIHJlbW92ZUZpbGVJdGVtO1xuICAgIHByaXZhdGUgZ2VuRXJyO1xuICAgIHByaXZhdGUgb25TdGFydDtcbiAgICBwcml2YXRlIG9uUHJvZ3Jlc3M7XG4gICAgcHJpdmF0ZSBvblN1Y2Nlc3M7XG4gICAgcHJpdmF0ZSBvbkVycm9yO1xuICAgIHByaXZhdGUgZHJhZ1N0YXRlO1xuICAgIGZpbGVEcm9wKGU6IGFueSk6IHZvaWQ7XG4gICAgcHJpdmF0ZSBkZXRlY3RDaGFuZ2VzTGlzdDtcbiAgICBvblJlbW92ZTogKGZpbGU6IFVwbG9hZEZpbGUpID0+IHZvaWQ7XG4gICAgcHJpdmF0ZSBwcmVmaXhDbHM7XG4gICAgY2xhc3NMaXN0OiBzdHJpbmdbXTtcbiAgICBwcml2YXRlIHNldENsYXNzTWFwO1xuICAgIG5nT25Jbml0KCk6IHZvaWQ7XG4gICAgbmdPbkNoYW5nZXMoY2hhbmdlczoge1xuICAgICAgICBbUCBpbiBrZXlvZiB0aGlzXT86IFNpbXBsZUNoYW5nZTtcbiAgICB9ICYgU2ltcGxlQ2hhbmdlcyk6IHZvaWQ7XG4gICAgbmdPbkRlc3Ryb3koKTogdm9pZDtcbn1cbiJdfQ==