/**
* @license
* Copyright Google Inc. All Rights Reserved.
*
* Use of this source code is governed by an MIT-style license that can be
* found in the LICENSE file at https://angular.io/license
*/
import { assertNumber, assertNumberInRange } from '../../util/assert';
export function toTStylingRange(prev, next) {
    ngDevMode && assertNumberInRange(prev, 0, 32767 /* UNSIGNED_MASK */);
    ngDevMode && assertNumberInRange(next, 0, 32767 /* UNSIGNED_MASK */);
    return (prev << 17 /* PREV_SHIFT */ | next << 2 /* NEXT_SHIFT */);
}
export function getTStylingRangePrev(tStylingRange) {
    ngDevMode && assertNumber(tStylingRange, 'expected number');
    return (tStylingRange >> 17 /* PREV_SHIFT */) & 32767 /* UNSIGNED_MASK */;
}
export function getTStylingRangePrevDuplicate(tStylingRange) {
    ngDevMode && assertNumber(tStylingRange, 'expected number');
    return (tStylingRange & 2 /* PREV_DUPLICATE */) ==
        2 /* PREV_DUPLICATE */;
}
export function setTStylingRangePrev(tStylingRange, previous) {
    ngDevMode && assertNumber(tStylingRange, 'expected number');
    ngDevMode && assertNumberInRange(previous, 0, 32767 /* UNSIGNED_MASK */);
    return ((tStylingRange & ~4294836224 /* PREV_MASK */) |
        (previous << 17 /* PREV_SHIFT */));
}
export function setTStylingRangePrevDuplicate(tStylingRange) {
    ngDevMode && assertNumber(tStylingRange, 'expected number');
    return (tStylingRange | 2 /* PREV_DUPLICATE */);
}
export function getTStylingRangeNext(tStylingRange) {
    ngDevMode && assertNumber(tStylingRange, 'expected number');
    return (tStylingRange & 131068 /* NEXT_MASK */) >> 2 /* NEXT_SHIFT */;
}
export function setTStylingRangeNext(tStylingRange, next) {
    ngDevMode && assertNumber(tStylingRange, 'expected number');
    ngDevMode && assertNumberInRange(next, 0, 32767 /* UNSIGNED_MASK */);
    return ((tStylingRange & ~131068 /* NEXT_MASK */) | //
        next << 2 /* NEXT_SHIFT */);
}
export function getTStylingRangeNextDuplicate(tStylingRange) {
    ngDevMode && assertNumber(tStylingRange, 'expected number');
    return (tStylingRange & 1 /* NEXT_DUPLICATE */) ===
        1 /* NEXT_DUPLICATE */;
}
export function setTStylingRangeNextDuplicate(tStylingRange) {
    ngDevMode && assertNumber(tStylingRange, 'expected number');
    return (tStylingRange | 1 /* NEXT_DUPLICATE */);
}
export function getTStylingRangeTail(tStylingRange) {
    ngDevMode && assertNumber(tStylingRange, 'expected number');
    var next = getTStylingRangeNext(tStylingRange);
    return next === 0 ? getTStylingRangePrev(tStylingRange) : next;
}
//# sourceMappingURL=data:application/json;base64,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