/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { Overlay } from '@angular/cdk/overlay';
import { ElementRef, ExistingProvider, NgZone, OnDestroy, ViewContainerRef } from '@angular/core';
import { ControlValueAccessor } from '@angular/forms';
import { NzAutocompleteOptionComponent } from './nz-autocomplete-option.component';
import { NzAutocompleteComponent } from './nz-autocomplete.component';
import * as ɵngcc0 from '@angular/core';
export declare const NZ_AUTOCOMPLETE_VALUE_ACCESSOR: ExistingProvider;
export declare function getNzAutocompleteMissingPanelError(): Error;
export declare class NzAutocompleteTriggerDirective implements ControlValueAccessor, OnDestroy {
    private elementRef;
    private overlay;
    private viewContainerRef;
    private ngZone;
    private document;
    /** Bind nzAutocomplete component */
    nzAutocomplete: NzAutocompleteComponent;
    _onChange: (value: any) => void;
    _onTouched: () => void;
    panelOpen: boolean;
    /** Current active option */
    readonly activeOption: NzAutocompleteOptionComponent | undefined;
    private overlayRef;
    private portal;
    private positionStrategy;
    private previousValue;
    private selectionChangeSubscription;
    private optionsChangeSubscription;
    private overlayBackdropClickSubscription;
    private overlayPositionChangeSubscription;
    constructor(elementRef: ElementRef, overlay: Overlay, viewContainerRef: ViewContainerRef, ngZone: NgZone, document: any);
    ngOnDestroy(): void;
    writeValue(value: any): void;
    registerOnChange(fn: (value: {}) => {}): void;
    registerOnTouched(fn: () => {}): void;
    setDisabledState(isDisabled: boolean): void;
    openPanel(): void;
    closePanel(): void;
    handleKeydown(event: KeyboardEvent): void;
    handleInput(event: KeyboardEvent): void;
    handleFocus(): void;
    handleBlur(): void;
    /**
     * Subscription data source changes event
     */
    private subscribeOptionsChange;
    /**
     * Subscription option changes event and set the value
     */
    private subscribeSelectionChange;
    /**
     * Subscription external click and close panel
     */
    private subscribeOverlayBackdropClick;
    /**
     * Subscription overlay position changes and reset dropdown position
     */
    private subscribeOverlayPositionChange;
    private attachOverlay;
    private updateStatus;
    private destroyPanel;
    private getOverlayConfig;
    private getConnectedElement;
    private getHostWidth;
    private getOverlayPosition;
    private resetActiveItem;
    private setValueAndClose;
    private setTriggerValue;
    private doBackfill;
    private canOpen;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzAutocompleteTriggerDirective>;
    static ɵdir: ɵngcc0.ɵɵDirectiveDefWithMeta<NzAutocompleteTriggerDirective, "input[nzAutocomplete], textarea[nzAutocomplete]", ["nzAutocompleteTrigger"], {
    "nzAutocomplete": "nzAutocomplete";
}, {}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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