/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { AfterContentInit, AfterViewInit, ChangeDetectorRef, ElementRef, EventEmitter, NgZone, OnDestroy, QueryList, TemplateRef } from '@angular/core';
import { Observable } from 'rxjs';
import { CompareWith, NzDropDownPosition, NzNoAnimationDirective } from 'ng-zorro-antd/core';
import { NzAutocompleteOptionComponent, NzOptionSelectionChange } from './nz-autocomplete-option.component';
import * as ɵngcc0 from '@angular/core';
export interface AutocompleteDataSourceItem {
    value: string;
    label: string;
}
export declare type AutocompleteDataSource = AutocompleteDataSourceItem[] | string[] | number[];
export declare class NzAutocompleteComponent implements AfterContentInit, AfterViewInit, OnDestroy {
    private changeDetectorRef;
    private ngZone;
    noAnimation?: NzNoAnimationDirective | undefined;
    nzWidth: number;
    nzOverlayClassName: string;
    nzOverlayStyle: {
        [key: string]: string;
    };
    nzDefaultActiveFirstOption: boolean;
    nzBackfill: boolean;
    compareWith: CompareWith;
    nzDataSource: AutocompleteDataSource;
    readonly selectionChange: EventEmitter<NzAutocompleteOptionComponent>;
    showPanel: boolean;
    isOpen: boolean;
    activeItem: NzAutocompleteOptionComponent;
    dropDownPosition: NzDropDownPosition;
    /**
     * Options accessor, its source may be content or dataSource
     */
    readonly options: QueryList<NzAutocompleteOptionComponent>;
    /** Provided by content */
    fromContentOptions: QueryList<NzAutocompleteOptionComponent>;
    /** Provided by dataSource */
    fromDataSourceOptions: QueryList<NzAutocompleteOptionComponent>;
    /** cdk-overlay */
    template: TemplateRef<{}>;
    panel: ElementRef;
    content: ElementRef;
    private activeItemIndex;
    private selectionChangeSubscription;
    private dataSourceChangeSubscription;
    /** Options changes listener */
    readonly optionSelectionChanges: Observable<NzOptionSelectionChange>;
    constructor(changeDetectorRef: ChangeDetectorRef, ngZone: NgZone, noAnimation?: NzNoAnimationDirective | undefined);
    ngAfterContentInit(): void;
    ngAfterViewInit(): void;
    ngOnDestroy(): void;
    setVisibility(): void;
    setActiveItem(index: number): void;
    setNextItemActive(): void;
    setPreviousItemActive(): void;
    getOptionIndex(value: any): number;
    updatePosition(position: NzDropDownPosition): void;
    private optionsInit;
    /**
     * Clear the status of options
     */
    clearSelectedOptions(skip?: NzAutocompleteOptionComponent | null, deselect?: boolean): void;
    private subscribeOptionChanges;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzAutocompleteComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzAutocompleteComponent, "nz-autocomplete", ["nzAutocomplete"], {
    "nzOverlayClassName": "nzOverlayClassName";
    "nzOverlayStyle": "nzOverlayStyle";
    "nzDefaultActiveFirstOption": "nzDefaultActiveFirstOption";
    "nzBackfill": "nzBackfill";
    "compareWith": "compareWith";
    "nzWidth": "nzWidth";
    "nzDataSource": "nzDataSource";
}, {
    "selectionChange": "selectionChange";
}, ["fromContentOptions"]>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibnotYXV0b2NvbXBsZXRlLmNvbXBvbmVudC5kLnRzIiwic291cmNlcyI6WyJuei1hdXRvY29tcGxldGUuY29tcG9uZW50LmQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOzs7Ozs7Ozs7Ozs7O0FBQ0EiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgQWxpYmFiYS5jb20gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2dpdGh1Yi5jb20vTkctWk9SUk8vbmctem9ycm8tYW50ZC9ibG9iL21hc3Rlci9MSUNFTlNFXG4gKi9cbmltcG9ydCB7IEFmdGVyQ29udGVudEluaXQsIEFmdGVyVmlld0luaXQsIENoYW5nZURldGVjdG9yUmVmLCBFbGVtZW50UmVmLCBFdmVudEVtaXR0ZXIsIE5nWm9uZSwgT25EZXN0cm95LCBRdWVyeUxpc3QsIFRlbXBsYXRlUmVmIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgeyBPYnNlcnZhYmxlIH0gZnJvbSAncnhqcyc7XG5pbXBvcnQgeyBDb21wYXJlV2l0aCwgTnpEcm9wRG93blBvc2l0aW9uLCBOek5vQW5pbWF0aW9uRGlyZWN0aXZlIH0gZnJvbSAnbmctem9ycm8tYW50ZC9jb3JlJztcbmltcG9ydCB7IE56QXV0b2NvbXBsZXRlT3B0aW9uQ29tcG9uZW50LCBOek9wdGlvblNlbGVjdGlvbkNoYW5nZSB9IGZyb20gJy4vbnotYXV0b2NvbXBsZXRlLW9wdGlvbi5jb21wb25lbnQnO1xuZXhwb3J0IGludGVyZmFjZSBBdXRvY29tcGxldGVEYXRhU291cmNlSXRlbSB7XG4gICAgdmFsdWU6IHN0cmluZztcbiAgICBsYWJlbDogc3RyaW5nO1xufVxuZXhwb3J0IGRlY2xhcmUgdHlwZSBBdXRvY29tcGxldGVEYXRhU291cmNlID0gQXV0b2NvbXBsZXRlRGF0YVNvdXJjZUl0ZW1bXSB8IHN0cmluZ1tdIHwgbnVtYmVyW107XG5leHBvcnQgZGVjbGFyZSBjbGFzcyBOekF1dG9jb21wbGV0ZUNvbXBvbmVudCBpbXBsZW1lbnRzIEFmdGVyQ29udGVudEluaXQsIEFmdGVyVmlld0luaXQsIE9uRGVzdHJveSB7XG4gICAgcHJpdmF0ZSBjaGFuZ2VEZXRlY3RvclJlZjtcbiAgICBwcml2YXRlIG5nWm9uZTtcbiAgICBub0FuaW1hdGlvbj86IE56Tm9BbmltYXRpb25EaXJlY3RpdmUgfCB1bmRlZmluZWQ7XG4gICAgbnpXaWR0aDogbnVtYmVyO1xuICAgIG56T3ZlcmxheUNsYXNzTmFtZTogc3RyaW5nO1xuICAgIG56T3ZlcmxheVN0eWxlOiB7XG4gICAgICAgIFtrZXk6IHN0cmluZ106IHN0cmluZztcbiAgICB9O1xuICAgIG56RGVmYXVsdEFjdGl2ZUZpcnN0T3B0aW9uOiBib29sZWFuO1xuICAgIG56QmFja2ZpbGw6IGJvb2xlYW47XG4gICAgY29tcGFyZVdpdGg6IENvbXBhcmVXaXRoO1xuICAgIG56RGF0YVNvdXJjZTogQXV0b2NvbXBsZXRlRGF0YVNvdXJjZTtcbiAgICByZWFkb25seSBzZWxlY3Rpb25DaGFuZ2U6IEV2ZW50RW1pdHRlcjxOekF1dG9jb21wbGV0ZU9wdGlvbkNvbXBvbmVudD47XG4gICAgc2hvd1BhbmVsOiBib29sZWFuO1xuICAgIGlzT3BlbjogYm9vbGVhbjtcbiAgICBhY3RpdmVJdGVtOiBOekF1dG9jb21wbGV0ZU9wdGlvbkNvbXBvbmVudDtcbiAgICBkcm9wRG93blBvc2l0aW9uOiBOekRyb3BEb3duUG9zaXRpb247XG4gICAgLyoqXG4gICAgICogT3B0aW9ucyBhY2Nlc3NvciwgaXRzIHNvdXJjZSBtYXkgYmUgY29udGVudCBvciBkYXRhU291cmNlXG4gICAgICovXG4gICAgcmVhZG9ubHkgb3B0aW9uczogUXVlcnlMaXN0PE56QXV0b2NvbXBsZXRlT3B0aW9uQ29tcG9uZW50PjtcbiAgICAvKiogUHJvdmlkZWQgYnkgY29udGVudCAqL1xuICAgIGZyb21Db250ZW50T3B0aW9uczogUXVlcnlMaXN0PE56QXV0b2NvbXBsZXRlT3B0aW9uQ29tcG9uZW50PjtcbiAgICAvKiogUHJvdmlkZWQgYnkgZGF0YVNvdXJjZSAqL1xuICAgIGZyb21EYXRhU291cmNlT3B0aW9uczogUXVlcnlMaXN0PE56QXV0b2NvbXBsZXRlT3B0aW9uQ29tcG9uZW50PjtcbiAgICAvKiogY2RrLW92ZXJsYXkgKi9cbiAgICB0ZW1wbGF0ZTogVGVtcGxhdGVSZWY8e30+O1xuICAgIHBhbmVsOiBFbGVtZW50UmVmO1xuICAgIGNvbnRlbnQ6IEVsZW1lbnRSZWY7XG4gICAgcHJpdmF0ZSBhY3RpdmVJdGVtSW5kZXg7XG4gICAgcHJpdmF0ZSBzZWxlY3Rpb25DaGFuZ2VTdWJzY3JpcHRpb247XG4gICAgcHJpdmF0ZSBkYXRhU291cmNlQ2hhbmdlU3Vic2NyaXB0aW9uO1xuICAgIC8qKiBPcHRpb25zIGNoYW5nZXMgbGlzdGVuZXIgKi9cbiAgICByZWFkb25seSBvcHRpb25TZWxlY3Rpb25DaGFuZ2VzOiBPYnNlcnZhYmxlPE56T3B0aW9uU2VsZWN0aW9uQ2hhbmdlPjtcbiAgICBjb25zdHJ1Y3RvcihjaGFuZ2VEZXRlY3RvclJlZjogQ2hhbmdlRGV0ZWN0b3JSZWYsIG5nWm9uZTogTmdab25lLCBub0FuaW1hdGlvbj86IE56Tm9BbmltYXRpb25EaXJlY3RpdmUgfCB1bmRlZmluZWQpO1xuICAgIG5nQWZ0ZXJDb250ZW50SW5pdCgpOiB2b2lkO1xuICAgIG5nQWZ0ZXJWaWV3SW5pdCgpOiB2b2lkO1xuICAgIG5nT25EZXN0cm95KCk6IHZvaWQ7XG4gICAgc2V0VmlzaWJpbGl0eSgpOiB2b2lkO1xuICAgIHNldEFjdGl2ZUl0ZW0oaW5kZXg6IG51bWJlcik6IHZvaWQ7XG4gICAgc2V0TmV4dEl0ZW1BY3RpdmUoKTogdm9pZDtcbiAgICBzZXRQcmV2aW91c0l0ZW1BY3RpdmUoKTogdm9pZDtcbiAgICBnZXRPcHRpb25JbmRleCh2YWx1ZTogYW55KTogbnVtYmVyO1xuICAgIHVwZGF0ZVBvc2l0aW9uKHBvc2l0aW9uOiBOekRyb3BEb3duUG9zaXRpb24pOiB2b2lkO1xuICAgIHByaXZhdGUgb3B0aW9uc0luaXQ7XG4gICAgLyoqXG4gICAgICogQ2xlYXIgdGhlIHN0YXR1cyBvZiBvcHRpb25zXG4gICAgICovXG4gICAgY2xlYXJTZWxlY3RlZE9wdGlvbnMoc2tpcD86IE56QXV0b2NvbXBsZXRlT3B0aW9uQ29tcG9uZW50IHwgbnVsbCwgZGVzZWxlY3Q/OiBib29sZWFuKTogdm9pZDtcbiAgICBwcml2YXRlIHN1YnNjcmliZU9wdGlvbkNoYW5nZXM7XG59XG4iXX0=