/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ElementRef, EventEmitter, OnInit } from '@angular/core';
import { CandyDate } from 'ng-zorro-antd/core';
import { DateHelperService, NzCalendarI18nInterface } from 'ng-zorro-antd/i18n';
import * as ɵngcc0 from '@angular/core';
export declare class CalendarInputComponent implements OnInit {
    private dateHelper;
    locale: NzCalendarI18nInterface;
    format: string;
    placeholder: string;
    disabledDate: (d: Date) => boolean;
    value: CandyDate;
    autoFocus: boolean;
    inputRef: ElementRef;
    readonly valueChange: EventEmitter<{
        date: CandyDate;
        isEnter: boolean;
    }>;
    prefixCls: string;
    invalidInputClass: string;
    constructor(dateHelper: DateHelperService);
    ngOnInit(): void;
    onInputKeyup(event: KeyboardEvent, isEnter?: boolean): void;
    toReadableInput(value: CandyDate): string;
    private checkValidInputDate;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<CalendarInputComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<CalendarInputComponent, "calendar-input", ["calendarInput"], {
    "value": "value";
    "locale": "locale";
    "format": "format";
    "placeholder": "placeholder";
    "disabledDate": "disabledDate";
    "autoFocus": "autoFocus";
}, {
    "valueChange": "valueChange";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2FsZW5kYXItaW5wdXQuY29tcG9uZW50LmQudHMiLCJzb3VyY2VzIjpbImNhbGVuZGFyLWlucHV0LmNvbXBvbmVudC5kLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Ozs7Ozs7Ozs7OztBQUNBIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEFsaWJhYmEuY29tIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogVXNlIG9mIHRoaXMgc291cmNlIGNvZGUgaXMgZ292ZXJuZWQgYnkgYW4gTUlULXN0eWxlIGxpY2Vuc2UgdGhhdCBjYW4gYmVcbiAqIGZvdW5kIGluIHRoZSBMSUNFTlNFIGZpbGUgYXQgaHR0cHM6Ly9naXRodWIuY29tL05HLVpPUlJPL25nLXpvcnJvLWFudGQvYmxvYi9tYXN0ZXIvTElDRU5TRVxuICovXG5pbXBvcnQgeyBFbGVtZW50UmVmLCBFdmVudEVtaXR0ZXIsIE9uSW5pdCB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgQ2FuZHlEYXRlIH0gZnJvbSAnbmctem9ycm8tYW50ZC9jb3JlJztcbmltcG9ydCB7IERhdGVIZWxwZXJTZXJ2aWNlLCBOekNhbGVuZGFySTE4bkludGVyZmFjZSB9IGZyb20gJ25nLXpvcnJvLWFudGQvaTE4bic7XG5leHBvcnQgZGVjbGFyZSBjbGFzcyBDYWxlbmRhcklucHV0Q29tcG9uZW50IGltcGxlbWVudHMgT25Jbml0IHtcbiAgICBwcml2YXRlIGRhdGVIZWxwZXI7XG4gICAgbG9jYWxlOiBOekNhbGVuZGFySTE4bkludGVyZmFjZTtcbiAgICBmb3JtYXQ6IHN0cmluZztcbiAgICBwbGFjZWhvbGRlcjogc3RyaW5nO1xuICAgIGRpc2FibGVkRGF0ZTogKGQ6IERhdGUpID0+IGJvb2xlYW47XG4gICAgdmFsdWU6IENhbmR5RGF0ZTtcbiAgICBhdXRvRm9jdXM6IGJvb2xlYW47XG4gICAgaW5wdXRSZWY6IEVsZW1lbnRSZWY7XG4gICAgcmVhZG9ubHkgdmFsdWVDaGFuZ2U6IEV2ZW50RW1pdHRlcjx7XG4gICAgICAgIGRhdGU6IENhbmR5RGF0ZTtcbiAgICAgICAgaXNFbnRlcjogYm9vbGVhbjtcbiAgICB9PjtcbiAgICBwcmVmaXhDbHM6IHN0cmluZztcbiAgICBpbnZhbGlkSW5wdXRDbGFzczogc3RyaW5nO1xuICAgIGNvbnN0cnVjdG9yKGRhdGVIZWxwZXI6IERhdGVIZWxwZXJTZXJ2aWNlKTtcbiAgICBuZ09uSW5pdCgpOiB2b2lkO1xuICAgIG9uSW5wdXRLZXl1cChldmVudDogS2V5Ym9hcmRFdmVudCwgaXNFbnRlcj86IGJvb2xlYW4pOiB2b2lkO1xuICAgIHRvUmVhZGFibGVJbnB1dCh2YWx1ZTogQ2FuZHlEYXRlKTogc3RyaW5nO1xuICAgIHByaXZhdGUgY2hlY2tWYWxpZElucHV0RGF0ZTtcbn1cbiJdfQ==