/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { AfterViewInit, ChangeDetectorRef, EventEmitter, Injector, OnChanges, OnDestroy, OnInit, Renderer2, SimpleChanges, TemplateRef, Type, ViewContainerRef } from '@angular/core';
import { FocusTrap, FocusTrapFactory } from '@angular/cdk/a11y';
import { Overlay, OverlayKeyboardDispatcher, OverlayRef } from '@angular/cdk/overlay';
import { CdkPortalOutlet, TemplatePortal } from '@angular/cdk/portal';
import { Observable, Subject } from 'rxjs';
import { NzConfigService } from 'ng-zorro-antd/core';
import { NzDrawerOptionsOfComponent, NzDrawerPlacement } from './nz-drawer-options';
import { NzDrawerRef } from './nz-drawer-ref';
import * as ɵngcc0 from '@angular/core';
export declare const DRAWER_ANIMATE_DURATION = 300;
export declare class NzDrawerComponent<T = any, R = any, D = any> extends NzDrawerRef<R> implements OnInit, OnDestroy, AfterViewInit, OnChanges, NzDrawerOptionsOfComponent {
    private document;
    nzConfigService: NzConfigService;
    private renderer;
    private overlay;
    private injector;
    private changeDetectorRef;
    private focusTrapFactory;
    private viewContainerRef;
    private overlayKeyboardDispatcher;
    nzContent: TemplateRef<{
        $implicit: D;
        drawerRef: NzDrawerRef<R>;
    }> | Type<T>;
    nzClosable: boolean;
    nzMaskClosable: boolean;
    nzMask: boolean;
    nzNoAnimation: boolean;
    nzKeyboard: boolean;
    nzTitle: string | TemplateRef<{}>;
    nzPlacement: NzDrawerPlacement;
    nzMaskStyle: object;
    nzBodyStyle: object;
    nzWrapClassName: string;
    nzWidth: number | string;
    nzHeight: number | string;
    nzZIndex: number;
    nzOffsetX: number;
    nzOffsetY: number;
    nzVisible: boolean;
    readonly nzOnViewInit: EventEmitter<void>;
    readonly nzOnClose: EventEmitter<MouseEvent>;
    drawerTemplate: TemplateRef<void>;
    bodyPortalOutlet: CdkPortalOutlet;
    destroy$: Subject<void>;
    previouslyFocusedElement: HTMLElement;
    nzContentParams: D;
    overlayRef: OverlayRef | null;
    portal: TemplatePortal;
    focusTrap: FocusTrap;
    isOpen: boolean;
    templateContext: {
        $implicit: D | undefined;
        drawerRef: NzDrawerRef<R>;
    };
    readonly offsetTransform: string | null;
    readonly transform: string | null;
    readonly width: string | null;
    readonly height: string | null;
    readonly isLeftOrRight: boolean;
    nzAfterOpen: Subject<void>;
    nzAfterClose: Subject<R>;
    readonly afterOpen: Observable<void>;
    readonly afterClose: Observable<R>;
    isTemplateRef(value: {}): boolean;
    constructor(document: any, nzConfigService: NzConfigService, renderer: Renderer2, overlay: Overlay, injector: Injector, changeDetectorRef: ChangeDetectorRef, focusTrapFactory: FocusTrapFactory, viewContainerRef: ViewContainerRef, overlayKeyboardDispatcher: OverlayKeyboardDispatcher);
    ngOnInit(): void;
    ngAfterViewInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngOnDestroy(): void;
    private getAnimationDuration;
    close(result?: R): void;
    open(): void;
    closeClick(): void;
    maskClick(): void;
    private attachBodyContent;
    private attachOverlay;
    private disposeOverlay;
    private getOverlayConfig;
    private updateOverlayStyle;
    private updateBodyOverflow;
    savePreviouslyFocusedElement(): void;
    private trapFocus;
    private restoreFocus;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzDrawerComponent<any, any, any>>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzDrawerComponent<any, any, any>, "nz-drawer", ["nzDrawer"], {
    "nzClosable": "nzClosable";
    "nzNoAnimation": "nzNoAnimation";
    "nzKeyboard": "nzKeyboard";
    "nzPlacement": "nzPlacement";
    "nzMaskStyle": "nzMaskStyle";
    "nzBodyStyle": "nzBodyStyle";
    "nzWidth": "nzWidth";
    "nzHeight": "nzHeight";
    "nzZIndex": "nzZIndex";
    "nzOffsetX": "nzOffsetX";
    "nzOffsetY": "nzOffsetY";
    "nzVisible": "nzVisible";
    "nzContent": "nzContent";
    "nzMaskClosable": "nzMaskClosable";
    "nzMask": "nzMask";
    "nzTitle": "nzTitle";
    "nzWrapClassName": "nzWrapClassName";
}, {
    "nzOnViewInit": "nzOnViewInit";
    "nzOnClose": "nzOnClose";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibnotZHJhd2VyLmNvbXBvbmVudC5kLnRzIiwic291cmNlcyI6WyJuei1kcmF3ZXIuY29tcG9uZW50LmQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBQ0EiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgQWxpYmFiYS5jb20gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2dpdGh1Yi5jb20vTkctWk9SUk8vbmctem9ycm8tYW50ZC9ibG9iL21hc3Rlci9MSUNFTlNFXG4gKi9cbmltcG9ydCB7IEFmdGVyVmlld0luaXQsIENoYW5nZURldGVjdG9yUmVmLCBFdmVudEVtaXR0ZXIsIEluamVjdG9yLCBPbkNoYW5nZXMsIE9uRGVzdHJveSwgT25Jbml0LCBSZW5kZXJlcjIsIFNpbXBsZUNoYW5nZXMsIFRlbXBsYXRlUmVmLCBUeXBlLCBWaWV3Q29udGFpbmVyUmVmIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgeyBGb2N1c1RyYXAsIEZvY3VzVHJhcEZhY3RvcnkgfSBmcm9tICdAYW5ndWxhci9jZGsvYTExeSc7XG5pbXBvcnQgeyBPdmVybGF5LCBPdmVybGF5S2V5Ym9hcmREaXNwYXRjaGVyLCBPdmVybGF5UmVmIH0gZnJvbSAnQGFuZ3VsYXIvY2RrL292ZXJsYXknO1xuaW1wb3J0IHsgQ2RrUG9ydGFsT3V0bGV0LCBUZW1wbGF0ZVBvcnRhbCB9IGZyb20gJ0Bhbmd1bGFyL2Nkay9wb3J0YWwnO1xuaW1wb3J0IHsgT2JzZXJ2YWJsZSwgU3ViamVjdCB9IGZyb20gJ3J4anMnO1xuaW1wb3J0IHsgTnpDb25maWdTZXJ2aWNlIH0gZnJvbSAnbmctem9ycm8tYW50ZC9jb3JlJztcbmltcG9ydCB7IE56RHJhd2VyT3B0aW9uc09mQ29tcG9uZW50LCBOekRyYXdlclBsYWNlbWVudCB9IGZyb20gJy4vbnotZHJhd2VyLW9wdGlvbnMnO1xuaW1wb3J0IHsgTnpEcmF3ZXJSZWYgfSBmcm9tICcuL256LWRyYXdlci1yZWYnO1xuZXhwb3J0IGRlY2xhcmUgY29uc3QgRFJBV0VSX0FOSU1BVEVfRFVSQVRJT04gPSAzMDA7XG5leHBvcnQgZGVjbGFyZSBjbGFzcyBOekRyYXdlckNvbXBvbmVudDxUID0gYW55LCBSID0gYW55LCBEID0gYW55PiBleHRlbmRzIE56RHJhd2VyUmVmPFI+IGltcGxlbWVudHMgT25Jbml0LCBPbkRlc3Ryb3ksIEFmdGVyVmlld0luaXQsIE9uQ2hhbmdlcywgTnpEcmF3ZXJPcHRpb25zT2ZDb21wb25lbnQge1xuICAgIHByaXZhdGUgZG9jdW1lbnQ7XG4gICAgbnpDb25maWdTZXJ2aWNlOiBOekNvbmZpZ1NlcnZpY2U7XG4gICAgcHJpdmF0ZSByZW5kZXJlcjtcbiAgICBwcml2YXRlIG92ZXJsYXk7XG4gICAgcHJpdmF0ZSBpbmplY3RvcjtcbiAgICBwcml2YXRlIGNoYW5nZURldGVjdG9yUmVmO1xuICAgIHByaXZhdGUgZm9jdXNUcmFwRmFjdG9yeTtcbiAgICBwcml2YXRlIHZpZXdDb250YWluZXJSZWY7XG4gICAgcHJpdmF0ZSBvdmVybGF5S2V5Ym9hcmREaXNwYXRjaGVyO1xuICAgIG56Q29udGVudDogVGVtcGxhdGVSZWY8e1xuICAgICAgICAkaW1wbGljaXQ6IEQ7XG4gICAgICAgIGRyYXdlclJlZjogTnpEcmF3ZXJSZWY8Uj47XG4gICAgfT4gfCBUeXBlPFQ+O1xuICAgIG56Q2xvc2FibGU6IGJvb2xlYW47XG4gICAgbnpNYXNrQ2xvc2FibGU6IGJvb2xlYW47XG4gICAgbnpNYXNrOiBib29sZWFuO1xuICAgIG56Tm9BbmltYXRpb246IGJvb2xlYW47XG4gICAgbnpLZXlib2FyZDogYm9vbGVhbjtcbiAgICBuelRpdGxlOiBzdHJpbmcgfCBUZW1wbGF0ZVJlZjx7fT47XG4gICAgbnpQbGFjZW1lbnQ6IE56RHJhd2VyUGxhY2VtZW50O1xuICAgIG56TWFza1N0eWxlOiBvYmplY3Q7XG4gICAgbnpCb2R5U3R5bGU6IG9iamVjdDtcbiAgICBueldyYXBDbGFzc05hbWU6IHN0cmluZztcbiAgICBueldpZHRoOiBudW1iZXIgfCBzdHJpbmc7XG4gICAgbnpIZWlnaHQ6IG51bWJlciB8IHN0cmluZztcbiAgICBuelpJbmRleDogbnVtYmVyO1xuICAgIG56T2Zmc2V0WDogbnVtYmVyO1xuICAgIG56T2Zmc2V0WTogbnVtYmVyO1xuICAgIG56VmlzaWJsZTogYm9vbGVhbjtcbiAgICByZWFkb25seSBuek9uVmlld0luaXQ6IEV2ZW50RW1pdHRlcjx2b2lkPjtcbiAgICByZWFkb25seSBuek9uQ2xvc2U6IEV2ZW50RW1pdHRlcjxNb3VzZUV2ZW50PjtcbiAgICBkcmF3ZXJUZW1wbGF0ZTogVGVtcGxhdGVSZWY8dm9pZD47XG4gICAgYm9keVBvcnRhbE91dGxldDogQ2RrUG9ydGFsT3V0bGV0O1xuICAgIGRlc3Ryb3kkOiBTdWJqZWN0PHZvaWQ+O1xuICAgIHByZXZpb3VzbHlGb2N1c2VkRWxlbWVudDogSFRNTEVsZW1lbnQ7XG4gICAgbnpDb250ZW50UGFyYW1zOiBEO1xuICAgIG92ZXJsYXlSZWY6IE92ZXJsYXlSZWYgfCBudWxsO1xuICAgIHBvcnRhbDogVGVtcGxhdGVQb3J0YWw7XG4gICAgZm9jdXNUcmFwOiBGb2N1c1RyYXA7XG4gICAgaXNPcGVuOiBib29sZWFuO1xuICAgIHRlbXBsYXRlQ29udGV4dDoge1xuICAgICAgICAkaW1wbGljaXQ6IEQgfCB1bmRlZmluZWQ7XG4gICAgICAgIGRyYXdlclJlZjogTnpEcmF3ZXJSZWY8Uj47XG4gICAgfTtcbiAgICByZWFkb25seSBvZmZzZXRUcmFuc2Zvcm06IHN0cmluZyB8IG51bGw7XG4gICAgcmVhZG9ubHkgdHJhbnNmb3JtOiBzdHJpbmcgfCBudWxsO1xuICAgIHJlYWRvbmx5IHdpZHRoOiBzdHJpbmcgfCBudWxsO1xuICAgIHJlYWRvbmx5IGhlaWdodDogc3RyaW5nIHwgbnVsbDtcbiAgICByZWFkb25seSBpc0xlZnRPclJpZ2h0OiBib29sZWFuO1xuICAgIG56QWZ0ZXJPcGVuOiBTdWJqZWN0PHZvaWQ+O1xuICAgIG56QWZ0ZXJDbG9zZTogU3ViamVjdDxSPjtcbiAgICByZWFkb25seSBhZnRlck9wZW46IE9ic2VydmFibGU8dm9pZD47XG4gICAgcmVhZG9ubHkgYWZ0ZXJDbG9zZTogT2JzZXJ2YWJsZTxSPjtcbiAgICBpc1RlbXBsYXRlUmVmKHZhbHVlOiB7fSk6IGJvb2xlYW47XG4gICAgY29uc3RydWN0b3IoZG9jdW1lbnQ6IGFueSwgbnpDb25maWdTZXJ2aWNlOiBOekNvbmZpZ1NlcnZpY2UsIHJlbmRlcmVyOiBSZW5kZXJlcjIsIG92ZXJsYXk6IE92ZXJsYXksIGluamVjdG9yOiBJbmplY3RvciwgY2hhbmdlRGV0ZWN0b3JSZWY6IENoYW5nZURldGVjdG9yUmVmLCBmb2N1c1RyYXBGYWN0b3J5OiBGb2N1c1RyYXBGYWN0b3J5LCB2aWV3Q29udGFpbmVyUmVmOiBWaWV3Q29udGFpbmVyUmVmLCBvdmVybGF5S2V5Ym9hcmREaXNwYXRjaGVyOiBPdmVybGF5S2V5Ym9hcmREaXNwYXRjaGVyKTtcbiAgICBuZ09uSW5pdCgpOiB2b2lkO1xuICAgIG5nQWZ0ZXJWaWV3SW5pdCgpOiB2b2lkO1xuICAgIG5nT25DaGFuZ2VzKGNoYW5nZXM6IFNpbXBsZUNoYW5nZXMpOiB2b2lkO1xuICAgIG5nT25EZXN0cm95KCk6IHZvaWQ7XG4gICAgcHJpdmF0ZSBnZXRBbmltYXRpb25EdXJhdGlvbjtcbiAgICBjbG9zZShyZXN1bHQ/OiBSKTogdm9pZDtcbiAgICBvcGVuKCk6IHZvaWQ7XG4gICAgY2xvc2VDbGljaygpOiB2b2lkO1xuICAgIG1hc2tDbGljaygpOiB2b2lkO1xuICAgIHByaXZhdGUgYXR0YWNoQm9keUNvbnRlbnQ7XG4gICAgcHJpdmF0ZSBhdHRhY2hPdmVybGF5O1xuICAgIHByaXZhdGUgZGlzcG9zZU92ZXJsYXk7XG4gICAgcHJpdmF0ZSBnZXRPdmVybGF5Q29uZmlnO1xuICAgIHByaXZhdGUgdXBkYXRlT3ZlcmxheVN0eWxlO1xuICAgIHByaXZhdGUgdXBkYXRlQm9keU92ZXJmbG93O1xuICAgIHNhdmVQcmV2aW91c2x5Rm9jdXNlZEVsZW1lbnQoKTogdm9pZDtcbiAgICBwcml2YXRlIHRyYXBGb2N1cztcbiAgICBwcml2YXRlIHJlc3RvcmVGb2N1cztcbn1cbiJdfQ==