/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ConnectionPositionPair, Overlay, OverlayConfig } from '@angular/cdk/overlay';
import { Platform } from '@angular/cdk/platform';
import { AfterViewInit, ElementRef, EventEmitter, OnChanges, OnDestroy, Renderer2, SimpleChanges, ViewContainerRef } from '@angular/core';
import { NzButtonComponent, NzButtonGroupComponent } from 'ng-zorro-antd/button';
import { Observable } from 'rxjs';
import { NzDropdownMenuComponent, NzPlacementType } from './nz-dropdown-menu.component';
import * as ɵngcc0 from '@angular/core';
export declare class NzDropDownDirective implements AfterViewInit, OnDestroy, OnChanges {
    elementRef: ElementRef;
    private renderer;
    private overlay;
    private platform;
    private nzButtonComponent;
    private nzButtonGroupComponent;
    private viewContainerRef;
    private portal;
    private overlayRef;
    private destroy$;
    private triggerWidth;
    private el;
    private dropdownOpen;
    private positionStrategy;
    private positions;
    private positionSubscription;
    private overlaySubscription;
    readonly hover$: Observable<boolean>;
    readonly $click: Observable<boolean>;
    nzDropdownMenu: NzDropdownMenuComponent;
    nzTrigger: 'click' | 'hover';
    nzMatchWidthElement: ElementRef;
    nzBackdrop: boolean;
    nzClickHide: boolean;
    nzDisabled: boolean;
    nzVisible: boolean;
    nzTableFilter: boolean;
    nzOverlayClassName: string;
    nzOverlayStyle: {
        [key: string]: string;
    };
    nzPlacement: NzPlacementType;
    readonly nzVisibleChange: EventEmitter<boolean>;
    setDisabled(disabled: boolean): void;
    private getOverlayConfig;
    private createOverlay;
    updateOverlayConfig(overlayConfig: OverlayConfig): OverlayConfig;
    dispose(): void;
    private subscribeToPositions;
    private subscribeOverlayEvent;
    private getPortal;
    private openMenu;
    private closeMenu;
    private setPosition;
    private updatePositionStrategy;
    private setTriggerWidth;
    initActionSubscribe(): void;
    updateOverlayByVisible(): void;
    updateDisabledState(): void;
    regeneratePosition(placement: NzPlacementType, positions: ConnectionPositionPair[]): ConnectionPositionPair[];
    constructor(elementRef: ElementRef, renderer: Renderer2, overlay: Overlay, platform: Platform, nzButtonComponent: NzButtonComponent, nzButtonGroupComponent: NzButtonGroupComponent, viewContainerRef: ViewContainerRef);
    ngAfterViewInit(): void;
    ngOnDestroy(): void;
    ngOnChanges(changes: SimpleChanges): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzDropDownDirective>;
    static ɵdir: ɵngcc0.ɵɵDirectiveDefWithMeta<NzDropDownDirective, "[nz-dropdown]", ["nzDropdown"], {
    "nzTrigger": "nzTrigger";
    "nzBackdrop": "nzBackdrop";
    "nzClickHide": "nzClickHide";
    "nzDisabled": "nzDisabled";
    "nzVisible": "nzVisible";
    "nzTableFilter": "nzTableFilter";
    "nzOverlayClassName": "nzOverlayClassName";
    "nzOverlayStyle": "nzOverlayStyle";
    "nzPlacement": "nzPlacement";
    "nzDropdownMenu": "nzDropdownMenu";
    "nzMatchWidthElement": "nzMatchWidthElement";
}, {
    "nzVisibleChange": "nzVisibleChange";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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