/**
 * @fileoverview added by tsickle
 * Generated from: util/measure-scrollbar.ts
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 * @type {?}
 */
let scrollbarVerticalSize;
/** @type {?} */
let scrollbarHorizontalSize;
// Measure scrollbar width for padding body during modal show/hide
/** @type {?} */
const scrollbarMeasure = {
    position: 'absolute',
    top: '-9999px',
    width: '50px',
    height: '50px'
};
/**
 * @param {?=} direction
 * @param {?=} prefix
 * @return {?}
 */
export function measureScrollbar(direction = 'vertical', prefix = 'ant') {
    if (typeof document === 'undefined' || typeof window === 'undefined') {
        return 0;
    }
    /** @type {?} */
    const isVertical = direction === 'vertical';
    if (isVertical && scrollbarVerticalSize) {
        return scrollbarVerticalSize;
    }
    else if (!isVertical && scrollbarHorizontalSize) {
        return scrollbarHorizontalSize;
    }
    /** @type {?} */
    const scrollDiv = document.createElement('div');
    Object.keys(scrollbarMeasure).forEach((/**
     * @param {?} scrollProp
     * @return {?}
     */
    scrollProp => {
        // @ts-ignore
        scrollDiv.style[scrollProp] = scrollbarMeasure[scrollProp];
    }));
    // apply hide scrollbar className ahead
    scrollDiv.className = `${prefix}-hide-scrollbar scroll-div-append-to-body`;
    // Append related overflow style
    if (isVertical) {
        scrollDiv.style.overflowY = 'scroll';
    }
    else {
        scrollDiv.style.overflowX = 'scroll';
    }
    document.body.appendChild(scrollDiv);
    /** @type {?} */
    let size = 0;
    if (isVertical) {
        size = scrollDiv.offsetWidth - scrollDiv.clientWidth;
        scrollbarVerticalSize = size;
    }
    else {
        size = scrollDiv.offsetHeight - scrollDiv.clientHeight;
        scrollbarHorizontalSize = size;
    }
    document.body.removeChild(scrollDiv);
    return size;
}
//# sourceMappingURL=data:application/json;base64,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