/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { Platform } from '@angular/cdk/platform';
import { AfterViewInit, DoCheck, ElementRef, NgZone, OnDestroy } from '@angular/core';
import { NzDomEventService } from 'ng-zorro-antd/core';
import * as ɵngcc0 from '@angular/core';
export interface AutoSizeType {
    minRows?: number;
    maxRows?: number;
}
export declare function isAutoSizeType(value: string | boolean | AutoSizeType): value is AutoSizeType;
export declare class NzAutosizeDirective implements AfterViewInit, OnDestroy, DoCheck {
    private elementRef;
    private ngZone;
    private platform;
    private nzDomEventService;
    private autosize;
    private el;
    private cachedLineHeight;
    private previousValue;
    private previousMinRows;
    private minRows;
    private maxRows;
    private destroy$;
    private inputGap;
    nzAutosize: string | boolean | AutoSizeType;
    resizeToFitContent(force?: boolean): void;
    private cacheTextareaLineHeight;
    setMinHeight(): void;
    setMaxHeight(): void;
    noopInputHandler(): void;
    constructor(elementRef: ElementRef, ngZone: NgZone, platform: Platform, nzDomEventService: NzDomEventService);
    ngAfterViewInit(): void;
    ngOnDestroy(): void;
    ngDoCheck(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzAutosizeDirective>;
    static ɵdir: ɵngcc0.ɵɵDirectiveDefWithMeta<NzAutosizeDirective, "textarea[nzAutosize]", ["nzAutosize"], {
    "nzAutosize": "nzAutosize";
}, {}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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