/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { CdkConnectedOverlay, ConnectedOverlayPositionChange } from '@angular/cdk/overlay';
import { Platform } from '@angular/cdk/platform';
import { AfterContentInit, ChangeDetectorRef, ElementRef, EventEmitter, OnChanges, OnDestroy, OnInit, QueryList, SimpleChanges, TemplateRef } from '@angular/core';
import { NzMenuBaseService, NzNoAnimationDirective, NzUpdateHostClassService } from 'ng-zorro-antd/core';
import { NzMenuItemDirective } from './nz-menu-item.directive';
import { NzSubmenuService } from './nz-submenu.service';
import * as ɵngcc0 from '@angular/core';
export declare class NzSubMenuComponent implements OnInit, OnDestroy, AfterContentInit, OnChanges {
    private elementRef;
    nzMenuService: NzMenuBaseService;
    private cdr;
    nzSubmenuService: NzSubmenuService;
    private nzUpdateHostClassService;
    private platform;
    noAnimation?: NzNoAnimationDirective | undefined;
    nzMenuClassName: string;
    nzPaddingLeft: number;
    nzTitle: string | TemplateRef<void>;
    nzIcon: string;
    nzOpen: boolean;
    nzDisabled: boolean;
    readonly nzOpenChange: EventEmitter<boolean>;
    cdkConnectedOverlay: CdkConnectedOverlay;
    cdkOverlayOrigin: ElementRef;
    listOfNzSubMenuComponent: QueryList<NzSubMenuComponent>;
    listOfNzMenuItemDirective: QueryList<NzMenuItemDirective>;
    placement: string;
    triggerWidth: number;
    expandState: string;
    overlayPositions: import("@angular/cdk/overlay").ConnectionPositionPair[];
    private destroy$;
    private isChildMenuSelected;
    private isMouseHover;
    setOpenState(open: boolean): void;
    clickSubMenuTitle(): void;
    setMouseEnterState(value: boolean): void;
    setTriggerWidth(): void;
    onPositionChange(position: ConnectedOverlayPositionChange): void;
    setClassMap(): void;
    constructor(elementRef: ElementRef, nzMenuService: NzMenuBaseService, cdr: ChangeDetectorRef, nzSubmenuService: NzSubmenuService, nzUpdateHostClassService: NzUpdateHostClassService, platform: Platform, noAnimation?: NzNoAnimationDirective | undefined);
    ngOnInit(): void;
    ngAfterContentInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngOnDestroy(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzSubMenuComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzSubMenuComponent, "[nz-submenu]", ["nzSubmenu"], {
    "nzOpen": "nzOpen";
    "nzDisabled": "nzDisabled";
    "nzMenuClassName": "nzMenuClassName";
    "nzPaddingLeft": "nzPaddingLeft";
    "nzTitle": "nzTitle";
    "nzIcon": "nzIcon";
}, {
    "nzOpenChange": "nzOpenChange";
}, ["listOfNzSubMenuComponent", "listOfNzMenuItemDirective"]>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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