/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ChangeDetectorRef, OnChanges, OnDestroy, OnInit, SimpleChanges, TemplateRef } from '@angular/core';
import { NzConfigService, NzSizeLDSType } from 'ng-zorro-antd/core';
import * as ɵngcc0 from '@angular/core';
export declare class NzSpinComponent implements OnChanges, OnDestroy, OnInit {
    nzConfigService: NzConfigService;
    private cdr;
    nzIndicator: TemplateRef<void>;
    nzSize: NzSizeLDSType;
    nzTip: string;
    nzDelay: number;
    nzSimple: boolean;
    nzSpinning: boolean;
    loading: boolean;
    private destroy$;
    private spinning$;
    private loading$;
    private loading_;
    subscribeLoading(): void;
    unsubscribeLoading(): void;
    constructor(nzConfigService: NzConfigService, cdr: ChangeDetectorRef);
    ngOnInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngOnDestroy(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzSpinComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzSpinComponent, "nz-spin", ["nzSpin"], {
    "nzSize": "nzSize";
    "nzDelay": "nzDelay";
    "nzSimple": "nzSimple";
    "nzSpinning": "nzSpinning";
    "nzIndicator": "nzIndicator";
    "nzTip": "nzTip";
}, {}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibnotc3Bpbi5jb21wb25lbnQuZC50cyIsInNvdXJjZXMiOlsibnotc3Bpbi5jb21wb25lbnQuZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7Ozs7Ozs7OztBQUNBIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEFsaWJhYmEuY29tIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogVXNlIG9mIHRoaXMgc291cmNlIGNvZGUgaXMgZ292ZXJuZWQgYnkgYW4gTUlULXN0eWxlIGxpY2Vuc2UgdGhhdCBjYW4gYmVcbiAqIGZvdW5kIGluIHRoZSBMSUNFTlNFIGZpbGUgYXQgaHR0cHM6Ly9naXRodWIuY29tL05HLVpPUlJPL25nLXpvcnJvLWFudGQvYmxvYi9tYXN0ZXIvTElDRU5TRVxuICovXG5pbXBvcnQgeyBDaGFuZ2VEZXRlY3RvclJlZiwgT25DaGFuZ2VzLCBPbkRlc3Ryb3ksIE9uSW5pdCwgU2ltcGxlQ2hhbmdlcywgVGVtcGxhdGVSZWYgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7IE56Q29uZmlnU2VydmljZSwgTnpTaXplTERTVHlwZSB9IGZyb20gJ25nLXpvcnJvLWFudGQvY29yZSc7XG5leHBvcnQgZGVjbGFyZSBjbGFzcyBOelNwaW5Db21wb25lbnQgaW1wbGVtZW50cyBPbkNoYW5nZXMsIE9uRGVzdHJveSwgT25Jbml0IHtcbiAgICBuekNvbmZpZ1NlcnZpY2U6IE56Q29uZmlnU2VydmljZTtcbiAgICBwcml2YXRlIGNkcjtcbiAgICBuekluZGljYXRvcjogVGVtcGxhdGVSZWY8dm9pZD47XG4gICAgbnpTaXplOiBOelNpemVMRFNUeXBlO1xuICAgIG56VGlwOiBzdHJpbmc7XG4gICAgbnpEZWxheTogbnVtYmVyO1xuICAgIG56U2ltcGxlOiBib29sZWFuO1xuICAgIG56U3Bpbm5pbmc6IGJvb2xlYW47XG4gICAgbG9hZGluZzogYm9vbGVhbjtcbiAgICBwcml2YXRlIGRlc3Ryb3kkO1xuICAgIHByaXZhdGUgc3Bpbm5pbmckO1xuICAgIHByaXZhdGUgbG9hZGluZyQ7XG4gICAgcHJpdmF0ZSBsb2FkaW5nXztcbiAgICBzdWJzY3JpYmVMb2FkaW5nKCk6IHZvaWQ7XG4gICAgdW5zdWJzY3JpYmVMb2FkaW5nKCk6IHZvaWQ7XG4gICAgY29uc3RydWN0b3IobnpDb25maWdTZXJ2aWNlOiBOekNvbmZpZ1NlcnZpY2UsIGNkcjogQ2hhbmdlRGV0ZWN0b3JSZWYpO1xuICAgIG5nT25Jbml0KCk6IHZvaWQ7XG4gICAgbmdPbkNoYW5nZXMoY2hhbmdlczogU2ltcGxlQ2hhbmdlcyk6IHZvaWQ7XG4gICAgbmdPbkRlc3Ryb3koKTogdm9pZDtcbn1cbiJdfQ==