/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { AnimationEvent } from '@angular/animations';
import { ElementRef, EventEmitter, OnChanges, OnInit, Renderer2 } from '@angular/core';
import { NzUpdateHostClassService } from 'ng-zorro-antd/core';
import * as ɵngcc0 from '@angular/core';
export declare class NzTagComponent implements OnInit, OnChanges {
    private renderer;
    private elementRef;
    private nzUpdateHostClassService;
    presetColor: boolean;
    nzMode: 'default' | 'closeable' | 'checkable';
    nzColor: string;
    nzChecked: boolean;
    nzNoAnimation: boolean;
    readonly nzAfterClose: EventEmitter<void>;
    readonly nzOnClose: EventEmitter<MouseEvent>;
    readonly nzCheckedChange: EventEmitter<boolean>;
    private isPresetColor;
    private updateClassMap;
    updateCheckedStatus(): void;
    closeTag(e: MouseEvent): void;
    afterAnimation(e: AnimationEvent): void;
    constructor(renderer: Renderer2, elementRef: ElementRef, nzUpdateHostClassService: NzUpdateHostClassService);
    ngOnInit(): void;
    ngOnChanges(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzTagComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzTagComponent, "nz-tag", ["nzTag"], {
    "nzMode": "nzMode";
    "nzChecked": "nzChecked";
    "nzNoAnimation": "nzNoAnimation";
    "nzColor": "nzColor";
}, {
    "nzAfterClose": "nzAfterClose";
    "nzOnClose": "nzOnClose";
    "nzCheckedChange": "nzCheckedChange";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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