/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { CdkOverlayOrigin, ConnectionPositionPair } from '@angular/cdk/overlay';
import { AfterViewInit, ChangeDetectorRef, ElementRef, EventEmitter, OnChanges, OnInit, Renderer2, SimpleChanges, TemplateRef } from '@angular/core';
import { ControlValueAccessor } from '@angular/forms';
import { NzConfigService, NzUpdateHostClassService as UpdateCls } from 'ng-zorro-antd/core';
import * as ɵngcc0 from '@angular/core';
export declare class NzTimePickerComponent implements ControlValueAccessor, OnInit, AfterViewInit, OnChanges {
    nzConfigService: NzConfigService;
    private element;
    private renderer;
    private updateCls;
    cdr: ChangeDetectorRef;
    private _value;
    private _onChange;
    private _onTouched;
    isInit: boolean;
    origin: CdkOverlayOrigin;
    overlayPositions: ConnectionPositionPair[];
    inputRef: ElementRef<HTMLInputElement>;
    nzSize: string | null;
    nzHourStep: number;
    nzMinuteStep: number;
    nzSecondStep: number;
    nzClearText: string;
    nzPopupClassName: string;
    nzPlaceHolder: string;
    nzAddOn: TemplateRef<void>;
    nzDefaultOpenValue: Date;
    nzDisabledHours: () => number[];
    nzDisabledMinutes: (hour: number) => number[];
    nzDisabledSeconds: (hour: number, minute: number) => number[];
    nzFormat: string;
    nzOpen: boolean;
    nzUse12Hours: boolean;
    readonly nzOpenChange: EventEmitter<boolean>;
    nzHideDisabledOptions: boolean;
    nzAllowEmpty: boolean;
    nzDisabled: boolean;
    nzAutoFocus: boolean;
    value: Date | null;
    open(): void;
    close(): void;
    updateAutoFocus(): void;
    onClickClearBtn(): void;
    private setClassMap;
    focus(): void;
    blur(): void;
    constructor(nzConfigService: NzConfigService, element: ElementRef, renderer: Renderer2, updateCls: UpdateCls, cdr: ChangeDetectorRef);
    ngOnInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngAfterViewInit(): void;
    writeValue(time: Date | null): void;
    registerOnChange(fn: (time: Date | null) => void): void;
    registerOnTouched(fn: () => void): void;
    setDisabledState(isDisabled: boolean): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzTimePickerComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzTimePickerComponent, "nz-time-picker", ["nzTimePicker"], {
    "nzSize": "nzSize";
    "nzPlaceHolder": "nzPlaceHolder";
    "nzDefaultOpenValue": "nzDefaultOpenValue";
    "nzOpen": "nzOpen";
    "nzHideDisabledOptions": "nzHideDisabledOptions";
    "nzDisabled": "nzDisabled";
    "nzAutoFocus": "nzAutoFocus";
    "nzFormat": "nzFormat";
    "nzHourStep": "nzHourStep";
    "nzMinuteStep": "nzMinuteStep";
    "nzSecondStep": "nzSecondStep";
    "nzClearText": "nzClearText";
    "nzPopupClassName": "nzPopupClassName";
    "nzAddOn": "nzAddOn";
    "nzDisabledHours": "nzDisabledHours";
    "nzDisabledMinutes": "nzDisabledMinutes";
    "nzDisabledSeconds": "nzDisabledSeconds";
    "nzUse12Hours": "nzUse12Hours";
    "nzAllowEmpty": "nzAllowEmpty";
}, {
    "nzOpenChange": "nzOpenChange";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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