/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { AfterViewInit, ComponentFactory, ComponentFactoryResolver, ComponentRef, ElementRef, EventEmitter, OnChanges, OnDestroy, OnInit, Renderer2, SimpleChanges, ViewContainerRef } from '@angular/core';
import { NgStyleInterface, NzNoAnimationDirective, NzTSType } from 'ng-zorro-antd/core';
import { Subject } from 'rxjs';
import { NzTooltipTrigger } from '../nz-tooltip.definitions';
import { NzTooltipBaseComponentLegacy } from './nz-tooltip-base-legacy.component';
import { NzTooltipBaseComponent } from './nz-tooltip-base.component';
import * as ɵngcc0 from '@angular/core';
export declare abstract class NzTooltipBaseDirective implements OnChanges, OnInit, OnDestroy, AfterViewInit {
    elementRef: ElementRef;
    protected hostView: ViewContainerRef;
    protected resolver: ComponentFactoryResolver;
    protected renderer: Renderer2;
    /**
     * @deprecated 9.0.0. This will always be `null`.
     */
    protected _tooltip?: NzTooltipBaseComponentLegacy | undefined;
    protected noAnimation?: NzNoAnimationDirective | undefined;
    directiveNameTitle?: NzTSType | null;
    specificTitle?: NzTSType | null;
    directiveNameContent?: NzTSType | null;
    specificContent?: NzTSType | null;
    specificTrigger?: NzTooltipTrigger;
    specificPlacement?: string;
    tooltipRef: ComponentRef<NzTooltipBaseComponent>;
    /**
     * @deprecated 9.0.0. This is deprecated and going to be removed in 9.0.0.
     * Please use a more specific API. Like `nzTooltipTitle`.
     */
    nzTitle: NzTSType | null;
    /**
     * @deprecated 9.0.0. This is deprecated and going to be removed in 9.0.0.
     * Please use a more specific API. Like `nzPopoverContent`.
     */
    nzContent: NzTSType | null;
    /**
     * @deprecated 9.0.0. This is deprecated and going to be removed in 9.0.0.
     * Please use a more specific API. Like `nzTooltipTrigger`.
     */
    nzTrigger: NzTooltipTrigger;
    /**
     * @deprecated 9.0.0. This is deprecated and going to be removed in 9.0.0.
     * Please use a more specific API. Like `nzTooltipPlacement`.
     */
    nzPlacement: string;
    nzMouseEnterDelay: number;
    nzMouseLeaveDelay: number;
    nzOverlayClassName: string;
    nzOverlayStyle: NgStyleInterface;
    nzVisible: boolean;
    /**
     * For create tooltip dynamically. This should be override for each different component.
     */
    protected componentFactory: ComponentFactory<NzTooltipBaseComponent>;
    /**
     * This true title that would be used in other parts on this component.
     */
    protected readonly title: NzTSType | null;
    protected readonly content: NzTSType | null;
    protected readonly placement: string;
    protected readonly trigger: NzTooltipTrigger;
    protected needProxyProperties: string[];
    readonly nzVisibleChange: EventEmitter<boolean>;
    tooltip: NzTooltipBaseComponent;
    isTooltipComponentVisible: boolean;
    /**
     * @deprecated 9.0.0. Tooltips would always be dynamic in 9.0.0.
     */
    protected isDynamicTooltip: boolean;
    protected readonly triggerUnlisteners: Array<() => void>;
    protected $destroy: Subject<void>;
    private delayTimer?;
    constructor(elementRef: ElementRef, hostView: ViewContainerRef, resolver: ComponentFactoryResolver, renderer: Renderer2, 
    /**
     * @deprecated 9.0.0. This will always be `null`.
     */
    _tooltip?: NzTooltipBaseComponentLegacy | undefined, noAnimation?: NzNoAnimationDirective | undefined);
    ngOnChanges(changes: SimpleChanges): void;
    ngOnInit(): void;
    ngAfterViewInit(): void;
    ngOnDestroy(): void;
    show(): void;
    hide(): void;
    /**
     * Force the component to update its position.
     */
    updatePosition(): void;
    /**
     * Create a dynamic tooltip component. This method can be override.
     */
    protected createDynamicTooltipComponent(): void;
    protected registerTriggers(): void;
    /**
     * Sync changed properties to the component and trigger change detection in that component.
     */
    protected updateChangedProperties(propertiesOrChanges: string[] | SimpleChanges): void;
    private updateComponentValue;
    private delayEnterLeave;
    private removeTriggerListeners;
    private clearTogglingTimer;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzTooltipBaseDirective>;
    static ɵdir: ɵngcc0.ɵɵDirectiveDefWithMeta<NzTooltipBaseDirective, never, never, {
    "nzTrigger": "nzTrigger";
    "nzPlacement": "nzPlacement";
    "nzTitle": "nzTitle";
    "nzContent": "nzContent";
    "nzMouseEnterDelay": "nzMouseEnterDelay";
    "nzMouseLeaveDelay": "nzMouseLeaveDelay";
    "nzOverlayClassName": "nzOverlayClassName";
    "nzOverlayStyle": "nzOverlayStyle";
    "nzVisible": "nzVisible";
}, {
    "nzVisibleChange": "nzVisibleChange";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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