/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { EventEmitter, OnChanges, SimpleChanges, TemplateRef } from '@angular/core';
import { CandyDate } from 'ng-zorro-antd/core';
import { DateHelperService } from 'ng-zorro-antd/i18n';
import * as ɵngcc0 from '@angular/core';
export declare class MonthTableComponent implements OnChanges {
    private dateHelper;
    value: CandyDate;
    prefixCls: string;
    monthCellRender: TemplateRef<{
        $implicit: Date;
    }>;
    monthFullCellRender: TemplateRef<{
        $implicit: Date;
    }>;
    readonly valueChange: EventEmitter<CandyDate>;
    disabledDate: (date: Date) => boolean;
    panelMonths: PanelMonthData[][];
    constructor(dateHelper: DateHelperService);
    ngOnChanges(changes: SimpleChanges): void;
    trackYear(_index: number): number;
    trackPanelMonth(_index: number, monthData: PanelMonthData): string;
    private render;
    private makePanelMonths;
    private chooseMonth;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<MonthTableComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<MonthTableComponent, "month-table", ["monthTable"], {
    "value": "value";
    "prefixCls": "prefixCls";
    "monthCellRender": "monthCellRender";
    "monthFullCellRender": "monthFullCellRender";
    "disabledDate": "disabledDate";
}, {
    "valueChange": "valueChange";
}, never>;
}
export interface PanelMonthData {
    disabled: boolean;
    content: string;
    month: number;
    title: string;
    classMap: object | null;
    onClick: VoidFunction | null;
    value: Date;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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