/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/** @internal */
export var CURRENCIES_EN = {
    'ADP': [undefined, undefined, 0],
    'AFN': [undefined, undefined, 0],
    'ALL': [undefined, undefined, 0],
    'AMD': [undefined, undefined, 2],
    'AOA': [undefined, 'Kz'],
    'ARS': [undefined, '$'],
    'AUD': ['A$', '$'],
    'BAM': [undefined, 'KM'],
    'BBD': [undefined, '$'],
    'BDT': [undefined, '৳'],
    'BHD': [undefined, undefined, 3],
    'BIF': [undefined, undefined, 0],
    'BMD': [undefined, '$'],
    'BND': [undefined, '$'],
    'BOB': [undefined, 'Bs'],
    'BRL': ['R$'],
    'BSD': [undefined, '$'],
    'BWP': [undefined, 'P'],
    'BYN': [undefined, 'р.', 2],
    'BYR': [undefined, undefined, 0],
    'BZD': [undefined, '$'],
    'CAD': ['CA$', '$', 2],
    'CHF': [undefined, undefined, 2],
    'CLF': [undefined, undefined, 4],
    'CLP': [undefined, '$', 0],
    'CNY': ['CN¥', '¥'],
    'COP': [undefined, '$', 2],
    'CRC': [undefined, '₡', 2],
    'CUC': [undefined, '$'],
    'CUP': [undefined, '$'],
    'CZK': [undefined, 'Kč', 2],
    'DJF': [undefined, undefined, 0],
    'DKK': [undefined, 'kr', 2],
    'DOP': [undefined, '$'],
    'EGP': [undefined, 'E£'],
    'ESP': [undefined, '₧', 0],
    'EUR': ['€'],
    'FJD': [undefined, '$'],
    'FKP': [undefined, '£'],
    'GBP': ['£'],
    'GEL': [undefined, '₾'],
    'GIP': [undefined, '£'],
    'GNF': [undefined, 'FG', 0],
    'GTQ': [undefined, 'Q'],
    'GYD': [undefined, '$', 2],
    'HKD': ['HK$', '$'],
    'HNL': [undefined, 'L'],
    'HRK': [undefined, 'kn'],
    'HUF': [undefined, 'Ft', 2],
    'IDR': [undefined, 'Rp', 2],
    'ILS': ['₪'],
    'INR': ['₹'],
    'IQD': [undefined, undefined, 0],
    'IRR': [undefined, undefined, 0],
    'ISK': [undefined, 'kr', 0],
    'ITL': [undefined, undefined, 0],
    'JMD': [undefined, '$'],
    'JOD': [undefined, undefined, 3],
    'JPY': ['¥', undefined, 0],
    'KHR': [undefined, '៛'],
    'KMF': [undefined, 'CF', 0],
    'KPW': [undefined, '₩', 0],
    'KRW': ['₩', undefined, 0],
    'KWD': [undefined, undefined, 3],
    'KYD': [undefined, '$'],
    'KZT': [undefined, '₸'],
    'LAK': [undefined, '₭', 0],
    'LBP': [undefined, 'L£', 0],
    'LKR': [undefined, 'Rs'],
    'LRD': [undefined, '$'],
    'LTL': [undefined, 'Lt'],
    'LUF': [undefined, undefined, 0],
    'LVL': [undefined, 'Ls'],
    'LYD': [undefined, undefined, 3],
    'MGA': [undefined, 'Ar', 0],
    'MGF': [undefined, undefined, 0],
    'MMK': [undefined, 'K', 0],
    'MNT': [undefined, '₮', 2],
    'MRO': [undefined, undefined, 0],
    'MUR': [undefined, 'Rs', 2],
    'MXN': ['MX$', '$'],
    'MYR': [undefined, 'RM'],
    'NAD': [undefined, '$'],
    'NGN': [undefined, '₦'],
    'NIO': [undefined, 'C$'],
    'NOK': [undefined, 'kr', 2],
    'NPR': [undefined, 'Rs'],
    'NZD': ['NZ$', '$'],
    'OMR': [undefined, undefined, 3],
    'PHP': [undefined, '₱'],
    'PKR': [undefined, 'Rs', 2],
    'PLN': [undefined, 'zł'],
    'PYG': [undefined, '₲', 0],
    'RON': [undefined, 'lei'],
    'RSD': [undefined, undefined, 0],
    'RUB': [undefined, '₽'],
    'RUR': [undefined, 'р.'],
    'RWF': [undefined, 'RF', 0],
    'SBD': [undefined, '$'],
    'SEK': [undefined, 'kr', 2],
    'SGD': [undefined, '$'],
    'SHP': [undefined, '£'],
    'SLL': [undefined, undefined, 0],
    'SOS': [undefined, undefined, 0],
    'SRD': [undefined, '$'],
    'SSP': [undefined, '£'],
    'STD': [undefined, undefined, 0],
    'STN': [undefined, 'Db'],
    'SYP': [undefined, '£', 0],
    'THB': [undefined, '฿'],
    'TMM': [undefined, undefined, 0],
    'TND': [undefined, undefined, 3],
    'TOP': [undefined, 'T$'],
    'TRL': [undefined, undefined, 0],
    'TRY': [undefined, '₺'],
    'TTD': [undefined, '$'],
    'TWD': ['NT$', '$', 2],
    'TZS': [undefined, undefined, 2],
    'UAH': [undefined, '₴'],
    'UGX': [undefined, undefined, 0],
    'USD': ['$'],
    'UYI': [undefined, undefined, 0],
    'UYU': [undefined, '$'],
    'UYW': [undefined, undefined, 4],
    'UZS': [undefined, undefined, 2],
    'VEF': [undefined, 'Bs', 2],
    'VND': ['₫', undefined, 0],
    'VUV': [undefined, undefined, 0],
    'XAF': ['FCFA', undefined, 0],
    'XCD': ['EC$', '$'],
    'XOF': ['CFA', undefined, 0],
    'XPF': ['CFPF', undefined, 0],
    'XXX': ['¤'],
    'YER': [undefined, undefined, 0],
    'ZAR': [undefined, 'R'],
    'ZMK': [undefined, undefined, 0],
    'ZMW': [undefined, 'ZK'],
    'ZWD': [undefined, undefined, 0]
};
//# sourceMappingURL=data:application/json;base64,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