/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { Platform } from '@angular/cdk/platform';
import { ChangeDetectorRef, ElementRef, OnDestroy, OnInit, Renderer2, TemplateRef } from '@angular/core';
import { NzAnchorComponent } from './nz-anchor.component';
import * as ɵngcc0 from '@angular/core';
export declare class NzAnchorLinkComponent implements OnInit, OnDestroy {
    elementRef: ElementRef;
    private anchorComp;
    private cdr;
    private platform;
    nzHref: string;
    titleStr: string | null;
    titleTpl: TemplateRef<void>;
    active: boolean;
    nzTitle: string | TemplateRef<void>;
    nzTemplate: TemplateRef<void>;
    constructor(elementRef: ElementRef, anchorComp: NzAnchorComponent, cdr: ChangeDetectorRef, platform: Platform, renderer: Renderer2);
    ngOnInit(): void;
    goToClick(e: Event): void;
    markForCheck(): void;
    ngOnDestroy(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzAnchorLinkComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzAnchorLinkComponent, "nz-link", ["nzLink"], {
    "nzHref": "nzHref";
    "nzTitle": "nzTitle";
}, {}, ["nzTemplate"]>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibnotYW5jaG9yLWxpbmsuY29tcG9uZW50LmQudHMiLCJzb3VyY2VzIjpbIm56LWFuY2hvci1saW5rLmNvbXBvbmVudC5kLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOzs7Ozs7QUFDQSIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCBBbGliYWJhLmNvbSBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqIFVzZSBvZiB0aGlzIHNvdXJjZSBjb2RlIGlzIGdvdmVybmVkIGJ5IGFuIE1JVC1zdHlsZSBsaWNlbnNlIHRoYXQgY2FuIGJlXG4gKiBmb3VuZCBpbiB0aGUgTElDRU5TRSBmaWxlIGF0IGh0dHBzOi8vZ2l0aHViLmNvbS9ORy1aT1JSTy9uZy16b3Jyby1hbnRkL2Jsb2IvbWFzdGVyL0xJQ0VOU0VcbiAqL1xuaW1wb3J0IHsgUGxhdGZvcm0gfSBmcm9tICdAYW5ndWxhci9jZGsvcGxhdGZvcm0nO1xuaW1wb3J0IHsgQ2hhbmdlRGV0ZWN0b3JSZWYsIEVsZW1lbnRSZWYsIE9uRGVzdHJveSwgT25Jbml0LCBSZW5kZXJlcjIsIFRlbXBsYXRlUmVmIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgeyBOekFuY2hvckNvbXBvbmVudCB9IGZyb20gJy4vbnotYW5jaG9yLmNvbXBvbmVudCc7XG5leHBvcnQgZGVjbGFyZSBjbGFzcyBOekFuY2hvckxpbmtDb21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQsIE9uRGVzdHJveSB7XG4gICAgZWxlbWVudFJlZjogRWxlbWVudFJlZjtcbiAgICBwcml2YXRlIGFuY2hvckNvbXA7XG4gICAgcHJpdmF0ZSBjZHI7XG4gICAgcHJpdmF0ZSBwbGF0Zm9ybTtcbiAgICBuekhyZWY6IHN0cmluZztcbiAgICB0aXRsZVN0cjogc3RyaW5nIHwgbnVsbDtcbiAgICB0aXRsZVRwbDogVGVtcGxhdGVSZWY8dm9pZD47XG4gICAgYWN0aXZlOiBib29sZWFuO1xuICAgIG56VGl0bGU6IHN0cmluZyB8IFRlbXBsYXRlUmVmPHZvaWQ+O1xuICAgIG56VGVtcGxhdGU6IFRlbXBsYXRlUmVmPHZvaWQ+O1xuICAgIGNvbnN0cnVjdG9yKGVsZW1lbnRSZWY6IEVsZW1lbnRSZWYsIGFuY2hvckNvbXA6IE56QW5jaG9yQ29tcG9uZW50LCBjZHI6IENoYW5nZURldGVjdG9yUmVmLCBwbGF0Zm9ybTogUGxhdGZvcm0sIHJlbmRlcmVyOiBSZW5kZXJlcjIpO1xuICAgIG5nT25Jbml0KCk6IHZvaWQ7XG4gICAgZ29Ub0NsaWNrKGU6IEV2ZW50KTogdm9pZDtcbiAgICBtYXJrRm9yQ2hlY2soKTogdm9pZDtcbiAgICBuZ09uRGVzdHJveSgpOiB2b2lkO1xufVxuIl19