/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { InjectionToken } from '@angular/core';
import { SafeUrl } from '@angular/platform-browser';
import { editor } from 'monaco-editor';
import IEditorConstructionOptions = editor.IEditorConstructionOptions;
import IDiffEditorConstructionOptions = editor.IDiffEditorConstructionOptions;
export declare type EditorOptions = IEditorConstructionOptions;
export declare type DiffEditorOptions = IDiffEditorConstructionOptions;
export declare type JoinedEditorOptions = EditorOptions | DiffEditorOptions;
export declare type NzEditorMode = 'normal' | 'diff';
export declare enum NzCodeEditorLoadingStatus {
    UNLOAD = "unload",
    LOADING = "loading",
    LOADED = "LOADED"
}
export interface NzCodeEditorConfig {
    assetsRoot?: string | SafeUrl;
    defaultEditorOption?: JoinedEditorOptions;
    useStaticLoading?: boolean;
    onLoad?(): void;
    onFirstEditorInit?(): void;
    onInit?(): void;
}
export declare const NZ_CODE_EDITOR_CONFIG: InjectionToken<NzCodeEditorConfig>;
export declare function NZ_CODE_EDITOR_CONFIG_FACTORY(): NzCodeEditorConfig;
