/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { EventEmitter, OnChanges, SimpleChanges } from '@angular/core';
import { CandyDate } from 'ng-zorro-antd/core';
import { NzCalendarI18nInterface } from 'ng-zorro-antd/i18n';
import * as ɵngcc0 from '@angular/core';
export declare class YearPanelComponent implements OnChanges {
    locale: NzCalendarI18nInterface;
    value: CandyDate;
    readonly valueChange: EventEmitter<CandyDate>;
    disabledDate: (date: Date) => boolean;
    readonly decadePanelShow: EventEmitter<void>;
    readonly currentYear: number;
    readonly startYear: number;
    readonly endYear: number;
    prefixCls: string;
    panelYears: PanelYearData[][];
    constructor();
    ngOnChanges(changes: SimpleChanges): void;
    previousDecade(): void;
    nextDecade(): void;
    trackPanelYear(_index: number, yearData: PanelYearData): string;
    private render;
    private gotoYear;
    private chooseYear;
    private makePanelYears;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<YearPanelComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<YearPanelComponent, "year-panel", ["yearPanel"], {
    "value": "value";
    "locale": "locale";
    "disabledDate": "disabledDate";
}, {
    "valueChange": "valueChange";
    "decadePanelShow": "decadePanelShow";
}, never>;
}
export interface PanelYearData {
    disabled: boolean;
    content: string;
    year: number;
    title: string;
    isCurrent: boolean;
    isLowerThanStart: boolean;
    isBiggerThanEnd: boolean;
    classMap: object | null;
    onClick: VoidFunction | null;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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