/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { CdkConnectedOverlay, CdkOverlayOrigin, ConnectedOverlayPositionChange } from '@angular/cdk/overlay';
import { Platform } from '@angular/cdk/platform';
import { AfterContentInit, AfterViewInit, ChangeDetectorRef, ElementRef, EventEmitter, OnDestroy, OnInit, QueryList, Renderer2, TemplateRef } from '@angular/core';
import { ControlValueAccessor } from '@angular/forms';
import { NzNoAnimationDirective, NzSizeLDSType } from 'ng-zorro-antd/core';
import { NzOptionGroupComponent } from './nz-option-group.component';
import { NzOptionComponent } from './nz-option.component';
import { TFilterOption } from './nz-option.pipe';
import { NzSelectTopControlComponent } from './nz-select-top-control.component';
import { NzSelectService } from './nz-select.service';
import * as ɵngcc0 from '@angular/core';
export declare class NzSelectComponent implements ControlValueAccessor, OnInit, AfterViewInit, OnDestroy, AfterContentInit {
    nzSelectService: NzSelectService;
    private cdr;
    private platform;
    noAnimation?: NzNoAnimationDirective | undefined;
    open: boolean;
    value: any | any[];
    onChange: (value: string | string[]) => void;
    onTouched: () => void;
    dropDownPosition: 'top' | 'center' | 'bottom';
    triggerWidth: number;
    private _disabled;
    private isInit;
    private destroy$;
    cdkOverlayOrigin: CdkOverlayOrigin;
    cdkConnectedOverlay: CdkConnectedOverlay;
    nzSelectTopControlComponent: NzSelectTopControlComponent;
    nzSelectTopControlElement: ElementRef;
    /** should move to nz-option-container when https://github.com/angular/angular/issues/20810 resolved **/
    listOfNzOptionComponent: QueryList<NzOptionComponent>;
    listOfNzOptionGroupComponent: QueryList<NzOptionGroupComponent>;
    readonly nzOnSearch: EventEmitter<string>;
    readonly nzScrollToBottom: EventEmitter<void>;
    readonly nzOpenChange: EventEmitter<boolean>;
    readonly nzBlur: EventEmitter<void>;
    readonly nzFocus: EventEmitter<void>;
    nzSize: NzSizeLDSType;
    nzDropdownClassName: string;
    nzDropdownMatchSelectWidth: boolean;
    nzDropdownStyle: {
        [key: string]: string;
    };
    nzNotFoundContent: string;
    nzAllowClear: boolean;
    nzShowSearch: boolean;
    nzLoading: boolean;
    nzAutoFocus: boolean;
    nzPlaceHolder: string;
    nzMaxTagCount: number;
    nzDropdownRender: TemplateRef<void>;
    nzCustomTemplate: TemplateRef<{
        $implicit: NzOptionComponent;
    }>;
    nzSuffixIcon: TemplateRef<void>;
    nzClearIcon: TemplateRef<void>;
    nzRemoveIcon: TemplateRef<void>;
    nzMenuItemSelectedIcon: TemplateRef<void>;
    nzShowArrow: boolean;
    nzTokenSeparators: string[];
    nzMaxTagPlaceholder: TemplateRef<{
        $implicit: any[];
    }>;
    nzAutoClearSearchValue: boolean;
    nzMaxMultipleCount: number;
    nzServerSearch: boolean;
    nzMode: 'default' | 'multiple' | 'tags';
    nzFilterOption: TFilterOption;
    compareWith: (o1: any, o2: any) => boolean;
    nzOpen: boolean;
    nzDisabled: boolean;
    readonly nzSelectTopControlDOM: HTMLElement;
    updateAutoFocus(): void;
    focus(): void;
    blur(): void;
    onFocus(): void;
    onBlur(): void;
    onKeyDown(event: KeyboardEvent): void;
    toggleDropDown(): void;
    closeDropDown(): void;
    onPositionChange(position: ConnectedOverlayPositionChange): void;
    updateCdkConnectedOverlayStatus(): void;
    updateCdkConnectedOverlayPositions(): void;
    constructor(renderer: Renderer2, nzSelectService: NzSelectService, cdr: ChangeDetectorRef, platform: Platform, elementRef: ElementRef, noAnimation?: NzNoAnimationDirective | undefined);
    /** update ngModel -> update listOfSelectedValue **/
    writeValue(value: any | any[]): void;
    registerOnChange(fn: (value: string | string[]) => void): void;
    registerOnTouched(fn: () => void): void;
    setDisabledState(isDisabled: boolean): void;
    ngOnInit(): void;
    ngAfterViewInit(): void;
    ngAfterContentInit(): void;
    ngOnDestroy(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzSelectComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzSelectComponent, "nz-select", ["nzSelect"], {
    "nzSize": "nzSize";
    "nzDropdownMatchSelectWidth": "nzDropdownMatchSelectWidth";
    "nzAllowClear": "nzAllowClear";
    "nzShowSearch": "nzShowSearch";
    "nzLoading": "nzLoading";
    "nzAutoFocus": "nzAutoFocus";
    "nzShowArrow": "nzShowArrow";
    "nzTokenSeparators": "nzTokenSeparators";
    "nzAutoClearSearchValue": "nzAutoClearSearchValue";
    "nzMaxMultipleCount": "nzMaxMultipleCount";
    "nzServerSearch": "nzServerSearch";
    "nzMode": "nzMode";
    "nzFilterOption": "nzFilterOption";
    "compareWith": "compareWith";
    "nzOpen": "nzOpen";
    "nzDisabled": "nzDisabled";
    "nzDropdownClassName": "nzDropdownClassName";
    "nzDropdownStyle": "nzDropdownStyle";
    "nzNotFoundContent": "nzNotFoundContent";
    "nzPlaceHolder": "nzPlaceHolder";
    "nzMaxTagCount": "nzMaxTagCount";
    "nzDropdownRender": "nzDropdownRender";
    "nzCustomTemplate": "nzCustomTemplate";
    "nzSuffixIcon": "nzSuffixIcon";
    "nzClearIcon": "nzClearIcon";
    "nzRemoveIcon": "nzRemoveIcon";
    "nzMenuItemSelectedIcon": "nzMenuItemSelectedIcon";
    "nzMaxTagPlaceholder": "nzMaxTagPlaceholder";
}, {
    "nzOnSearch": "nzOnSearch";
    "nzScrollToBottom": "nzScrollToBottom";
    "nzOpenChange": "nzOpenChange";
    "nzBlur": "nzBlur";
    "nzFocus": "nzFocus";
}, ["listOfNzOptionComponent", "listOfNzOptionGroupComponent"]>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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