/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ChangeDetectorRef, EventEmitter, OnChanges, OnDestroy, OnInit, SimpleChange, TemplateRef } from '@angular/core';
import { ControlValueAccessor } from '@angular/forms';
import { Observable, ReplaySubject, Subject } from 'rxjs';
import { NzConfigService, NzFormatBeforeDropEvent, NzFormatEmitEvent, NzNoAnimationDirective, NzTreeBase, NzTreeBaseService, NzTreeNode } from 'ng-zorro-antd/core';
import { NzTreeService } from './nz-tree.service';
import * as ɵngcc0 from '@angular/core';
export declare function NzTreeServiceFactory(higherOrderService: NzTreeBaseService, treeService: NzTreeService): NzTreeBaseService;
export declare class NzTreeComponent extends NzTreeBase implements OnInit, OnDestroy, ControlValueAccessor, OnChanges {
    nzConfigService: NzConfigService;
    private cdr;
    noAnimation?: NzNoAnimationDirective | undefined;
    nzShowIcon: boolean;
    nzShowExpand: boolean;
    nzShowLine: boolean;
    nzExpandedIcon: TemplateRef<{
        $implicit: NzTreeNode;
    }>;
    nzCheckable: boolean;
    nzAsyncData: boolean;
    nzDraggable: boolean;
    nzHideUnMatched: boolean;
    nzSelectMode: boolean;
    nzCheckStrictly: boolean;
    nzBlockNode: boolean;
    nzExpandAll: boolean;
    nzTreeTemplate: TemplateRef<{
        $implicit: NzTreeNode;
    }>;
    nzTreeTemplateChild: TemplateRef<{
        $implicit: NzTreeNode;
    }>;
    readonly treeTemplate: TemplateRef<{
        $implicit: NzTreeNode;
    }>;
    /**
     * @deprecated 9.0.0 use `nzExpandAll` instead.
     */
    nzDefaultExpandAll: boolean;
    private _nzDefaultExpandAll;
    nzBeforeDrop: (confirm: NzFormatBeforeDropEvent) => Observable<boolean>;
    nzMultiple: boolean;
    nzData: any[];
    /**
     * @deprecated 9.0.0 - use `nzExpandedKeys` instead.
     */
    nzDefaultExpandedKeys: string[];
    /**
     * @deprecated 9.0.0 - use `nzSelectedKeys` instead.
     */
    nzDefaultSelectedKeys: string[];
    /**
     * @deprecated 9.0.0 - use `nzCheckedKeys` instead.
     */
    nzDefaultCheckedKeys: string[];
    nzExpandedKeys: string[];
    nzSelectedKeys: string[];
    nzCheckedKeys: string[];
    nzSearchValue: string;
    /**
     * To render nodes if root is changed.
     */
    readonly nzNodes: NzTreeNode[];
    readonly nzExpandedKeysChange: EventEmitter<string[]>;
    readonly nzSelectedKeysChange: EventEmitter<string[]>;
    readonly nzCheckedKeysChange: EventEmitter<string[]>;
    readonly nzSearchValueChange: EventEmitter<NzFormatEmitEvent>;
    /**
     * @deprecated use `nzSearchValueChange` instead.
     */
    readonly nzOnSearchNode: EventEmitter<NzFormatEmitEvent>;
    readonly nzClick: EventEmitter<NzFormatEmitEvent>;
    readonly nzDblClick: EventEmitter<NzFormatEmitEvent>;
    readonly nzContextMenu: EventEmitter<NzFormatEmitEvent>;
    readonly nzCheckBoxChange: EventEmitter<NzFormatEmitEvent>;
    readonly nzExpandChange: EventEmitter<NzFormatEmitEvent>;
    readonly nzOnDragStart: EventEmitter<NzFormatEmitEvent>;
    readonly nzOnDragEnter: EventEmitter<NzFormatEmitEvent>;
    readonly nzOnDragOver: EventEmitter<NzFormatEmitEvent>;
    readonly nzOnDragLeave: EventEmitter<NzFormatEmitEvent>;
    readonly nzOnDrop: EventEmitter<NzFormatEmitEvent>;
    readonly nzOnDragEnd: EventEmitter<NzFormatEmitEvent>;
    _searchValue: string;
    nzDefaultSubject: ReplaySubject<{
        type: string;
        keys: string[];
    }>;
    destroy$: Subject<unknown>;
    prefixCls: string;
    classMap: {};
    onChange: (value: NzTreeNode[]) => void;
    onTouched: () => void;
    setClassMap(): void;
    writeValue(value: NzTreeNode[]): void;
    registerOnChange(fn: (_: NzTreeNode[]) => void): void;
    registerOnTouched(fn: () => void): void;
    initNzData(value: any[]): void;
    constructor(nzTreeService: NzTreeBaseService, nzConfigService: NzConfigService, cdr: ChangeDetectorRef, noAnimation?: NzNoAnimationDirective | undefined);
    ngOnInit(): void;
    ngOnChanges(changes: {
        [propertyName: string]: SimpleChange;
    }): void;
    ngOnDestroy(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzTreeComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzTreeComponent, "nz-tree", ["nzTree"], {
    "nzShowExpand": "nzShowExpand";
    "nzShowLine": "nzShowLine";
    "nzCheckable": "nzCheckable";
    "nzAsyncData": "nzAsyncData";
    "nzDraggable": "nzDraggable";
    "nzSelectMode": "nzSelectMode";
    "nzCheckStrictly": "nzCheckStrictly";
    "nzExpandAll": "nzExpandAll";
    "nzMultiple": "nzMultiple";
    "nzDefaultExpandAll": "nzDefaultExpandAll";
    "nzData": "nzData";
    "nzDefaultExpandedKeys": "nzDefaultExpandedKeys";
    "nzDefaultSelectedKeys": "nzDefaultSelectedKeys";
    "nzDefaultCheckedKeys": "nzDefaultCheckedKeys";
    "nzExpandedKeys": "nzExpandedKeys";
    "nzSelectedKeys": "nzSelectedKeys";
    "nzCheckedKeys": "nzCheckedKeys";
    "nzSearchValue": "nzSearchValue";
    "nzShowIcon": "nzShowIcon";
    "nzExpandedIcon": "nzExpandedIcon";
    "nzHideUnMatched": "nzHideUnMatched";
    "nzBlockNode": "nzBlockNode";
    "nzTreeTemplate": "nzTreeTemplate";
    "nzBeforeDrop": "nzBeforeDrop";
}, {
    "nzExpandedKeysChange": "nzExpandedKeysChange";
    "nzSelectedKeysChange": "nzSelectedKeysChange";
    "nzCheckedKeysChange": "nzCheckedKeysChange";
    "nzSearchValueChange": "nzSearchValueChange";
    "nzOnSearchNode": "nzOnSearchNode";
    "nzClick": "nzClick";
    "nzDblClick": "nzDblClick";
    "nzContextMenu": "nzContextMenu";
    "nzCheckBoxChange": "nzCheckBoxChange";
    "nzExpandChange": "nzExpandChange";
    "nzOnDragStart": "nzOnDragStart";
    "nzOnDragEnter": "nzOnDragEnter";
    "nzOnDragOver": "nzOnDragOver";
    "nzOnDragLeave": "nzOnDragLeave";
    "nzOnDrop": "nzOnDrop";
    "nzOnDragEnd": "nzOnDragEnd";
}, ["nzTreeTemplateChild"]>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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