/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { Platform } from '@angular/cdk/platform';
import { AfterViewInit, ElementRef, EventEmitter, NgZone, OnChanges, OnDestroy, SimpleChanges } from '@angular/core';
import { NzConfigService, NzScrollService } from 'ng-zorro-antd/core';
import * as ɵngcc0 from '@angular/core';
interface SimpleRect {
    top: number;
    left: number;
    width?: number;
    height?: number;
    bottom?: number;
}
export declare class NzAffixComponent implements AfterViewInit, OnChanges, OnDestroy {
    nzConfigService: NzConfigService;
    private scrollSrv;
    private ngZone;
    private platform;
    private fixedEl;
    nzTarget: string | Element | Window;
    nzOffsetTop: null | number;
    nzOffsetBottom: null | number;
    readonly nzChange: EventEmitter<boolean>;
    private readonly placeholderNode;
    private affixStyle?;
    private placeholderStyle?;
    private scroll$;
    private timeout?;
    private document;
    private readonly target;
    constructor(el: ElementRef, doc: any, // tslint:disable-line no-any
    nzConfigService: NzConfigService, scrollSrv: NzScrollService, ngZone: NgZone, platform: Platform);
    ngOnChanges(changes: SimpleChanges): void;
    ngAfterViewInit(): void;
    ngOnDestroy(): void;
    private registerListeners;
    private removeListeners;
    getOffset(element: Element, target: Element | Window | undefined): SimpleRect;
    private getTargetRect;
    private setAffixStyle;
    private setPlaceholderStyle;
    private syncPlaceholderStyle;
    updatePosition(e: Event): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzAffixComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzAffixComponent, "nz-affix", ["nzAffix"], {
    "nzTarget": "nzTarget";
    "nzOffsetTop": "nzOffsetTop";
    "nzOffsetBottom": "nzOffsetBottom";
}, {
    "nzChange": "nzChange";
}, never>;
}
export {};

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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