/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { EventEmitter, OnChanges, OnInit, SimpleChanges, TemplateRef } from '@angular/core';
import { CandyDate, FunctionProp } from 'ng-zorro-antd/core';
import { DateHelperService, NzCalendarI18nInterface, NzI18nService } from 'ng-zorro-antd/i18n';
import * as ɵngcc0 from '@angular/core';
export declare class DateTableComponent implements OnChanges, OnInit {
    private i18n;
    private dateHelper;
    _value: CandyDate;
    headWeekDays: WeekDayLabel[];
    weekRows: WeekRow[];
    prefixCls: string;
    locale: NzCalendarI18nInterface;
    selectedValue: CandyDate[];
    hoverValue: CandyDate[];
    value: CandyDate;
    activeDate: CandyDate;
    showWeek: boolean;
    disabledDate: (d: Date) => boolean;
    dateCellRender: FunctionProp<TemplateRef<Date> | string>;
    dateFullCellRender: FunctionProp<TemplateRef<Date> | string>;
    readonly dayHover: EventEmitter<CandyDate>;
    readonly valueChange: EventEmitter<CandyDate>;
    constructor(i18n: NzI18nService, dateHelper: DateHelperService);
    ngOnInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    private isDateRealChange;
    private isSameDate;
    private render;
    private changeValueFromInside;
    private makeHeadWeekDays;
    private getVeryShortWeekFormat;
    private makeWeekRows;
    trackByDateFn(_index: number, item: DateCell): string;
    trackByWeekFn(_index: number, item: WeekRow): string;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<DateTableComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<DateTableComponent, "date-table", ["dateTable"], {
    "prefixCls": "prefixCls";
    "showWeek": "showWeek";
    "value": "value";
    "activeDate": "activeDate";
    "locale": "locale";
    "selectedValue": "selectedValue";
    "hoverValue": "hoverValue";
    "disabledDate": "disabledDate";
    "dateCellRender": "dateCellRender";
    "dateFullCellRender": "dateFullCellRender";
}, {
    "dayHover": "dayHover";
    "valueChange": "valueChange";
}, never>;
}
export interface WeekDayLabel {
    short: string;
    veryShort: string;
}
export interface DateCell {
    value: Date;
    label: string;
    title: string;
    dateCellRender: TemplateRef<Date> | string;
    dateFullCellRender: TemplateRef<Date> | string;
    content: string;
    isSelected?: boolean;
    isToday?: boolean;
    isDisabled?: boolean;
    isSelectedStartDate?: boolean;
    isSelectedEndDate?: boolean;
    isInRange?: boolean;
    classMap?: object;
    onClick(date: CandyDate): void;
    onMouseEnter(): void;
}
export interface WeekRow {
    isCurrent?: boolean;
    isActive?: boolean;
    weekNum?: number;
    year?: number;
    classMap?: object;
    dateCells: DateCell[];
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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