/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { NzTreeNodeBaseComponent } from './nz-tree-base.definitions';
import { NzTreeBaseService } from './nz-tree-base.service';
export interface NzTreeNodeOptions {
    title: string;
    key: string;
    icon?: string;
    isLeaf?: boolean;
    checked?: boolean;
    selected?: boolean;
    selectable?: boolean;
    disabled?: boolean;
    disableCheckbox?: boolean;
    expanded?: boolean;
    children?: NzTreeNodeOptions[];
    [key: string]: any;
}
export declare class NzTreeNode {
    private _title;
    key: string;
    level: number;
    origin: NzTreeNodeOptions;
    parentNode: NzTreeNode | null;
    private _icon;
    private _children;
    private _isLeaf;
    private _isChecked;
    /**
     * @deprecated Maybe removed in next major version, use isChecked instead
     */
    private _isAllChecked;
    private _isSelectable;
    private _isDisabled;
    private _isDisableCheckbox;
    private _isExpanded;
    private _isHalfChecked;
    private _isSelected;
    private _isLoading;
    canHide: boolean;
    isMatched: boolean;
    service: NzTreeBaseService | null;
    component: NzTreeNodeBaseComponent;
    readonly treeService: NzTreeBaseService | null;
    constructor(option: NzTreeNodeOptions | NzTreeNode, parent?: NzTreeNode | null, service?: NzTreeBaseService | null);
    /**
     * auto generate
     * get
     * set
     */
    title: string;
    icon: string;
    children: NzTreeNode[];
    isLeaf: boolean;
    isChecked: boolean;
    /**
    * @deprecated Maybe removed in next major version, use `isChecked` instead.
    */
    isAllChecked: boolean;
    isHalfChecked: boolean;
    isSelectable: boolean;
    isDisabled: boolean;
    isDisableCheckbox: boolean;
    isExpanded: boolean;
    isSelected: boolean;
    isLoading: boolean;
    setSyncChecked(checked?: boolean, halfChecked?: boolean): void;
    /**
     * @deprecated Maybe removed in next major version, use `isChecked` instead.
     */
    setChecked(checked?: boolean, halfChecked?: boolean): void;
    /**
     * @deprecated Maybe removed in next major version, use `isExpanded` instead.
     */
    setExpanded(value: boolean): void;
    /**
     * @deprecated Maybe removed in next major version, use `isSelected` instead.
     */
    setSelected(value: boolean): void;
    getParentNode(): NzTreeNode | null;
    getChildren(): NzTreeNode[];
    /**
     * Support appending child nodes by position. Leaf node cannot be appended.
     */
    addChildren(children: any[], childPos?: number): void;
    clearChildren(): void;
    remove(): void;
    afterValueChange(key: string): void;
    update(): void;
}
