/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { AfterContentInit, AfterViewInit, ChangeDetectorRef, ElementRef, OnDestroy, OnInit, Renderer2, TemplateRef } from '@angular/core';
import { FormControl, FormControlDirective, FormControlName, NgModel } from '@angular/forms';
import { NgClassType, NzUpdateHostClassService } from 'ng-zorro-antd/core';
import { NzColDirective, NzRowDirective } from 'ng-zorro-antd/grid';
import { NzFormItemComponent } from './nz-form-item.component';
import * as ɵngcc0 from '@angular/core';
export declare type NzFormControlStatusType = 'warning' | 'validating' | 'error' | 'success' | null;
export declare class NzFormControlComponent extends NzColDirective implements OnDestroy, OnInit, AfterContentInit, AfterViewInit, OnDestroy {
    private nzFormItemComponent;
    private cdr;
    private _hasFeedback;
    private validateChanges;
    private validateString;
    validateControl: FormControl | NgModel | null;
    status: NzFormControlStatusType;
    controlClassMap: NgClassType;
    iconType: string;
    defaultValidateControl: FormControlName | FormControlDirective;
    nzSuccessTip: string | TemplateRef<{
        $implicit: FormControl | NgModel;
    }>;
    nzWarningTip: string | TemplateRef<{
        $implicit: FormControl | NgModel;
    }>;
    nzErrorTip: string | TemplateRef<{
        $implicit: FormControl | NgModel;
    }>;
    nzValidatingTip: string | TemplateRef<{
        $implicit: FormControl | NgModel;
    }>;
    nzExtra: string | TemplateRef<void>;
    nzHasFeedback: boolean;
    nzValidateStatus: string | FormControl | FormControlName | NgModel;
    removeSubscribe(): void;
    watchControl(): void;
    validateControlStatus(status: string): boolean;
    setControlClassMap(): void;
    readonly hasTips: boolean;
    readonly showSuccessTip: boolean;
    readonly showWarningTip: boolean;
    readonly showErrorTip: boolean;
    readonly showValidatingTip: boolean;
    readonly showInnerTip: boolean;
    constructor(nzUpdateHostClassService: NzUpdateHostClassService, elementRef: ElementRef, nzFormItemComponent: NzFormItemComponent, nzRowDirective: NzRowDirective, cdr: ChangeDetectorRef, renderer: Renderer2);
    ngOnInit(): void;
    ngOnDestroy(): void;
    ngAfterContentInit(): void;
    ngAfterViewInit(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzFormControlComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzFormControlComponent, "nz-form-control", ["nzFormControl"], {
    "nzHasFeedback": "nzHasFeedback";
    "nzValidateStatus": "nzValidateStatus";
    "nzSuccessTip": "nzSuccessTip";
    "nzWarningTip": "nzWarningTip";
    "nzErrorTip": "nzErrorTip";
    "nzValidatingTip": "nzValidatingTip";
    "nzExtra": "nzExtra";
}, {}, ["defaultValidateControl"]>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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