/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { AfterContentInit, ElementRef, EventEmitter, OnChanges, OnDestroy, OnInit, QueryList, SimpleChanges } from '@angular/core';
import { NzDirectionVHIType, NzMenuBaseService, NzUpdateHostClassService } from 'ng-zorro-antd/core';
import { NzMenuItemDirective } from './nz-menu-item.directive';
import { NzSubMenuComponent } from './nz-submenu.component';
import * as ɵngcc0 from '@angular/core';
export declare class NzMenuDirective implements AfterContentInit, OnInit, OnChanges, OnDestroy {
    elementRef: ElementRef;
    private nzMenuService;
    private nzUpdateHostClassService;
    private destroy$;
    private cacheMode;
    private listOfOpenedNzSubMenuComponent;
    listOfNzMenuItemDirective: QueryList<NzMenuItemDirective>;
    listOfNzSubMenuComponent: QueryList<NzSubMenuComponent>;
    nzInlineIndent: number;
    nzTheme: 'light' | 'dark';
    nzMode: NzDirectionVHIType;
    nzInDropDown: boolean;
    nzInlineCollapsed: boolean;
    nzSelectable: boolean;
    readonly nzClick: EventEmitter<NzMenuItemDirective>;
    updateInlineCollapse(): void;
    setClassMap(): void;
    constructor(elementRef: ElementRef, nzMenuService: NzMenuBaseService, nzUpdateHostClassService: NzUpdateHostClassService);
    ngOnInit(): void;
    ngAfterContentInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngOnDestroy(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzMenuDirective>;
    static ɵdir: ɵngcc0.ɵɵDirectiveDefWithMeta<NzMenuDirective, "[nz-menu]", ["nzMenu"], {
    "nzInlineIndent": "nzInlineIndent";
    "nzTheme": "nzTheme";
    "nzMode": "nzMode";
    "nzInDropDown": "nzInDropDown";
    "nzInlineCollapsed": "nzInlineCollapsed";
    "nzSelectable": "nzSelectable";
}, {
    "nzClick": "nzClick";
}, ["listOfNzMenuItemDirective", "listOfNzSubMenuComponent"]>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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