/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { Overlay } from '@angular/cdk/overlay';
import { Observable } from 'rxjs';
import { NzModalControlService } from './nz-modal-control.service';
import { NzModalRef } from './nz-modal-ref.class';
import { NzModalComponent } from './nz-modal.component';
import { ConfirmType, ModalOptionsForService } from './nz-modal.type';
import * as ɵngcc0 from '@angular/core';
export declare class ModalBuilderForService {
    private overlay;
    private modalRef;
    private overlayRef;
    constructor(overlay: Overlay, options?: ModalOptionsForService);
    getInstance(): NzModalComponent | null;
    destroyModal(): void;
    private changeProps;
    private createModal;
}
export declare class NzModalService {
    private overlay;
    private modalControl;
    readonly openModals: NzModalRef[];
    readonly afterAllClose: Observable<void>;
    constructor(overlay: Overlay, modalControl: NzModalControlService);
    closeAll(): void;
    create<T>(options?: ModalOptionsForService<T>): NzModalRef<T>;
    confirm<T>(options?: ModalOptionsForService<T>, confirmType?: ConfirmType): NzModalRef<T>;
    info<T>(options?: ModalOptionsForService<T>): NzModalRef<T>;
    success<T>(options?: ModalOptionsForService<T>): NzModalRef<T>;
    error<T>(options?: ModalOptionsForService<T>): NzModalRef<T>;
    warning<T>(options?: ModalOptionsForService<T>): NzModalRef<T>;
    private simpleConfirm;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzModalService>;
    static ɵprov: ɵngcc0.ɵɵInjectableDef<NzModalService>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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