"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const testing_1 = require("@angular-devkit/schematics/testing");
const test_app_1 = require("../../testing/test-app");
describe('ng-component schematic', () => {
    let runner;
    let appTree;
    beforeEach(() => __awaiter(this, void 0, void 0, function* () {
        runner = new testing_1.SchematicTestRunner('schematics', require.resolve('../../collection.json'));
        appTree = yield test_app_1.createTestApp(runner);
    }));
    it('should update app.component.html', () => __awaiter(this, void 0, void 0, function* () {
        const appComponentHTMLPath = '/projects/ng-zorro/src/app/app.component.html';
        const tree = yield runner.runSchematicAsync('blank', {}, appTree).toPromise();
        const appComponentHTML = tree.readContent(appComponentHTMLPath);
        const files = tree.files;
        expect(files).toEqual(jasmine.arrayContaining([appComponentHTMLPath]));
        expect(appComponentHTML).toContain('href="https://github.com/NG-ZORRO/ng-zorro-antd"');
    }));
});
//# sourceMappingURL=index.spec.js.map