/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { CdkConnectedOverlay } from '@angular/cdk/overlay';
import { ChangeDetectorRef, EventEmitter, OnChanges } from '@angular/core';
import { NgStyleInterface, NzNoAnimationDirective } from 'ng-zorro-antd/core';
import { NzTooltipTrigger } from '../nz-tooltip.definitions';
import { NzTooltipBaseComponent } from './nz-tooltip-base.component';
/**
 * This component overrides some properties of `NzTooltipBaseComponent` and make them
 * input properties.
 *
 * @deprecated 9.0.0 tooltip and other components deprecate the old API. This
 * would be removed in 9.0.0.
 *
 * @example This example is what going to be removed
 *
 * ```html
 * <nz-tooltip>
 *   <a nz-tooltip></a>
 * </nz-tooltip>
 * ```
 */
import * as ɵngcc0 from '@angular/core';
export declare class NzTooltipBaseComponentLegacy extends NzTooltipBaseComponent implements OnChanges {
    noAnimation?: NzNoAnimationDirective | undefined;
    overlay: CdkConnectedOverlay;
    nzOverlayClassName: string;
    nzOverlayStyle: NgStyleInterface;
    nzMouseEnterDelay: number;
    nzMouseLeaveDelay: number;
    nzPlacement: string;
    nzVisible: boolean;
    nzTrigger: NzTooltipTrigger;
    readonly nzVisibleChange: EventEmitter<boolean>;
    constructor(cdr: ChangeDetectorRef, noAnimation?: NzNoAnimationDirective | undefined);
    ngOnChanges(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzTooltipBaseComponentLegacy>;
    static ɵdir: ɵngcc0.ɵɵDirectiveDefWithMeta<NzTooltipBaseComponentLegacy, never, never, {
    "nzOverlayClassName": "nzOverlayClassName";
    "nzOverlayStyle": "nzOverlayStyle";
    "nzMouseEnterDelay": "nzMouseEnterDelay";
    "nzMouseLeaveDelay": "nzMouseLeaveDelay";
    "nzPlacement": "nzPlacement";
    "nzVisible": "nzVisible";
    "nzTrigger": "nzTrigger";
}, {
    "nzVisibleChange": "nzVisibleChange";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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