/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { CdkConnectedOverlay, CdkOverlayOrigin, ConnectedOverlayPositionChange } from '@angular/cdk/overlay';
import { ChangeDetectorRef, ElementRef, EventEmitter, Injector, OnChanges, OnDestroy, OnInit, Renderer2, SimpleChanges, TemplateRef } from '@angular/core';
import { ControlValueAccessor } from '@angular/forms';
import { Subscription } from 'rxjs';
import { NzConfigService, NzFormatEmitEvent, NzNoAnimationDirective, NzSizeLDSType, NzTreeBase, NzTreeBaseService, NzTreeNode, NzTreeNodeOptions } from 'ng-zorro-antd/core';
import { NzTreeComponent } from 'ng-zorro-antd/tree';
import { NzTreeSelectService } from './nz-tree-select.service';
import * as ɵngcc0 from '@angular/core';
export declare function higherOrderServiceFactory(injector: Injector): NzTreeBaseService;
export declare class NzTreeSelectComponent extends NzTreeBase implements ControlValueAccessor, OnInit, OnDestroy, OnChanges {
    nzConfigService: NzConfigService;
    private renderer;
    private cdr;
    private elementRef;
    noAnimation?: NzNoAnimationDirective | undefined;
    nzAllowClear: boolean;
    nzShowExpand: boolean;
    nzShowLine: boolean;
    nzDropdownMatchSelectWidth: boolean;
    nzCheckable: boolean;
    nzHideUnMatched: boolean;
    nzShowIcon: boolean;
    nzShowSearch: boolean;
    nzDisabled: boolean;
    nzAsyncData: boolean;
    nzMultiple: boolean;
    nzDefaultExpandAll: boolean;
    nzCheckStrictly: boolean;
    nzExpandedIcon: TemplateRef<{
        $implicit: NzTreeNode;
    }>;
    nzNotFoundContent: string;
    nzNodes: Array<NzTreeNode | NzTreeNodeOptions>;
    nzOpen: boolean;
    nzSize: NzSizeLDSType;
    nzPlaceHolder: string;
    nzDropdownStyle: {
        [key: string]: string;
    };
    /**
     * @deprecated 9.0.0 - use `nzExpandedKeys` instead.
     */
    nzDefaultExpandedKeys: string[];
    nzExpandedKeys: string[];
    nzDisplayWith: (node: NzTreeNode) => string | undefined;
    nzMaxTagCount: number;
    nzMaxTagPlaceholder: TemplateRef<{
        $implicit: NzTreeNode[];
    }>;
    readonly nzOpenChange: EventEmitter<boolean>;
    readonly nzCleared: EventEmitter<void>;
    readonly nzRemoved: EventEmitter<NzTreeNode>;
    readonly nzExpandChange: EventEmitter<NzFormatEmitEvent>;
    readonly nzTreeClick: EventEmitter<NzFormatEmitEvent>;
    readonly nzTreeCheckBoxChange: EventEmitter<NzFormatEmitEvent>;
    inputElement: ElementRef<HTMLInputElement>;
    treeRef: NzTreeComponent;
    cdkOverlayOrigin: CdkOverlayOrigin;
    cdkConnectedOverlay: CdkConnectedOverlay;
    nzTreeTemplate: TemplateRef<{
        $implicit: NzTreeNode;
    }>;
    nzTreeTemplateChild: TemplateRef<{
        $implicit: NzTreeNode;
    }>;
    readonly treeTemplate: TemplateRef<{
        $implicit: NzTreeNode;
    }>;
    triggerWidth: number;
    isComposing: boolean;
    isDestroy: boolean;
    isNotFound: boolean;
    inputValue: string;
    dropDownPosition: 'top' | 'center' | 'bottom';
    selectionChangeSubscription: Subscription;
    selectedNodes: NzTreeNode[];
    expandedKeys: string[];
    value: string[];
    onChange: (value: string[] | string | null) => void;
    onTouched: () => void;
    readonly placeHolderDisplay: string;
    readonly searchDisplay: string;
    readonly isMultiple: boolean;
    readonly selectedValueDisplay: {
        [key: string]: string;
    };
    constructor(nzTreeService: NzTreeSelectService, nzConfigService: NzConfigService, renderer: Renderer2, cdr: ChangeDetectorRef, elementRef: ElementRef, noAnimation?: NzNoAnimationDirective | undefined);
    ngOnInit(): void;
    ngOnDestroy(): void;
    setDisabledState(isDisabled: boolean): void;
    ngOnChanges(changes: SimpleChanges): void;
    writeValue(value: string[] | string): void;
    registerOnChange(fn: (_: string[] | string | null) => void): void;
    registerOnTouched(fn: () => void): void;
    trigger(): void;
    openDropdown(): void;
    closeDropDown(): void;
    onKeyDownInput(e: KeyboardEvent): void;
    onExpandedKeysChange(value: NzFormatEmitEvent): void;
    setInputValue(value: string): void;
    removeSelected(node: NzTreeNode, emit?: boolean, event?: MouseEvent): void;
    focusOnInput(): void;
    subscribeSelectionChange(): Subscription;
    updateSelectedNodes(init?: boolean): void;
    updatePosition(): void;
    onPositionChange(position: ConnectedOverlayPositionChange): void;
    updateInputWidth(): void;
    onClearSelection($event: MouseEvent): void;
    setSearchValues($event: NzFormatEmitEvent): void;
    updateCdkConnectedOverlayStatus(): void;
    trackValue(_index: number, option: NzTreeNode): string;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzTreeSelectComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzTreeSelectComponent, "nz-tree-select", ["nzTreeSelect"], {
    "nzAllowClear": "nzAllowClear";
    "nzShowExpand": "nzShowExpand";
    "nzShowLine": "nzShowLine";
    "nzCheckable": "nzCheckable";
    "nzShowSearch": "nzShowSearch";
    "nzDisabled": "nzDisabled";
    "nzAsyncData": "nzAsyncData";
    "nzMultiple": "nzMultiple";
    "nzDefaultExpandAll": "nzDefaultExpandAll";
    "nzCheckStrictly": "nzCheckStrictly";
    "nzNodes": "nzNodes";
    "nzOpen": "nzOpen";
    "nzPlaceHolder": "nzPlaceHolder";
    "nzDisplayWith": "nzDisplayWith";
    "nzDefaultExpandedKeys": "nzDefaultExpandedKeys";
    "nzExpandedKeys": "nzExpandedKeys";
    "nzDropdownMatchSelectWidth": "nzDropdownMatchSelectWidth";
    "nzHideUnMatched": "nzHideUnMatched";
    "nzShowIcon": "nzShowIcon";
    "nzExpandedIcon": "nzExpandedIcon";
    "nzNotFoundContent": "nzNotFoundContent";
    "nzSize": "nzSize";
    "nzDropdownStyle": "nzDropdownStyle";
    "nzMaxTagCount": "nzMaxTagCount";
    "nzMaxTagPlaceholder": "nzMaxTagPlaceholder";
    "nzTreeTemplate": "nzTreeTemplate";
}, {
    "nzOpenChange": "nzOpenChange";
    "nzCleared": "nzCleared";
    "nzRemoved": "nzRemoved";
    "nzExpandChange": "nzExpandChange";
    "nzTreeClick": "nzTreeClick";
    "nzTreeCheckBoxChange": "nzTreeCheckBoxChange";
}, ["nzTreeTemplateChild"]>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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