/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { Platform } from '@angular/cdk/platform';
import { AfterViewInit, ChangeDetectorRef, ElementRef, EmbeddedViewRef, EventEmitter, OnChanges, OnDestroy, OnInit, Renderer2, SimpleChanges, TemplateRef, ViewContainerRef } from '@angular/core';
import { NzConfigService, NzDomEventService } from 'ng-zorro-antd/core';
import { NzI18nService } from 'ng-zorro-antd/i18n';
import { NzTextCopyComponent } from './nz-text-copy.component';
import { NzTextEditComponent } from './nz-text-edit.component';
import * as ɵngcc0 from '@angular/core';
export declare class NzTypographyComponent implements OnInit, AfterViewInit, OnDestroy, OnChanges {
    nzConfigService: NzConfigService;
    private host;
    private cdr;
    private viewContainerRef;
    private renderer;
    private platform;
    private i18n;
    private nzDomEventService;
    nzCopyable: boolean;
    nzEditable: boolean;
    nzDisabled: boolean;
    nzExpandable: boolean;
    nzEllipsis: boolean;
    nzContent: string;
    nzEllipsisRows: number;
    nzType: 'secondary' | 'warning' | 'danger' | undefined;
    nzCopyText: string | undefined;
    readonly nzContentChange: EventEmitter<string>;
    readonly nzCopy: EventEmitter<string>;
    readonly nzExpandChange: EventEmitter<void>;
    textEditRef: NzTextEditComponent;
    textCopyRef: NzTextCopyComponent;
    ellipsisContainer: ElementRef<HTMLSpanElement>;
    expandableBtn: ElementRef<HTMLSpanElement>;
    contentTemplate: TemplateRef<{
        content: string;
    }>;
    locale: any;
    editing: boolean;
    ellipsisText: string | undefined;
    cssEllipsis: boolean;
    isEllipsis: boolean;
    expanded: boolean;
    ellipsisStr: string;
    readonly canCssEllipsis: boolean;
    private viewInit;
    private rfaId;
    private destroy$;
    private windowResizeSubscription;
    readonly copyText: string;
    constructor(nzConfigService: NzConfigService, host: ElementRef<HTMLElement>, cdr: ChangeDetectorRef, viewContainerRef: ViewContainerRef, renderer: Renderer2, platform: Platform, i18n: NzI18nService, nzDomEventService: NzDomEventService);
    onTextCopy(text: string): void;
    onStartEditing(): void;
    onEndEditing(text: string): void;
    onExpand(): void;
    canUseCSSEllipsis(): boolean;
    renderOnNextFrame(): void;
    getOriginContentViewRef(): {
        viewRef: EmbeddedViewRef<{
            content: string;
        }>;
        removeView(): void;
    };
    syncEllipsis(): void;
    private renderAndSubscribeWindowResize;
    ngOnInit(): void;
    ngAfterViewInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngOnDestroy(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzTypographyComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzTypographyComponent, "  nz-typography,  [nz-typography],  p[nz-paragraph],  span[nz-text],  h1[nz-title], h2[nz-title], h3[nz-title], h4[nz-title]  ", ["nzTypography"], {
    "nzCopyable": "nzCopyable";
    "nzEditable": "nzEditable";
    "nzDisabled": "nzDisabled";
    "nzExpandable": "nzExpandable";
    "nzEllipsis": "nzEllipsis";
    "nzContent": "nzContent";
    "nzEllipsisRows": "nzEllipsisRows";
    "nzType": "nzType";
    "nzCopyText": "nzCopyText";
}, {
    "nzContentChange": "nzContentChange";
    "nzCopy": "nzCopy";
    "nzExpandChange": "nzExpandChange";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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