/**
 * @fileoverview added by tsickle
 * Generated from: packages/core/src/di/injectable.ts
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { makeDecorator } from '../util/decorators';
import { getInjectableDef, ɵɵdefineInjectable } from './interface/defs';
import { compileInjectable as render3CompileInjectable } from './jit/injectable';
import { convertInjectableProviderToFactory } from './util';
/**
 * Type of the Injectable decorator / constructor function.
 *
 * \@publicApi
 * @record
 */
export function InjectableDecorator() { }
// WARNING: interface has both a type and a value, skipping emit
const ɵ0 = /**
 * @param {?} type
 * @param {?} meta
 * @return {?}
 */
(type, meta) => SWITCH_COMPILE_INJECTABLE((/** @type {?} */ (type)), meta);
/**
 * Injectable decorator and metadata.
 *
 * \@Annotation
 * \@publicApi
 * @type {?}
 */
export const Injectable = makeDecorator('Injectable', undefined, undefined, undefined, (ɵ0));
/**
 * Supports \@Injectable() in JIT mode for Render2.
 * @param {?} injectableType
 * @param {?=} options
 * @return {?}
 */
function render2CompileInjectable(injectableType, options) {
    if (options && options.providedIn !== undefined && !getInjectableDef(injectableType)) {
        ((/** @type {?} */ (injectableType))).ɵprov = ɵɵdefineInjectable({
            token: injectableType,
            providedIn: options.providedIn,
            factory: convertInjectableProviderToFactory(injectableType, options),
        });
    }
}
/** @type {?} */
export const SWITCH_COMPILE_INJECTABLE__POST_R3__ = render3CompileInjectable;
/** @type {?} */
const SWITCH_COMPILE_INJECTABLE__PRE_R3__ = render2CompileInjectable;
/** @type {?} */
const SWITCH_COMPILE_INJECTABLE = SWITCH_COMPILE_INJECTABLE__PRE_R3__;
export { ɵ0 };
//# sourceMappingURL=data:application/json;base64,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