/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { BehaviorSubject, Subject } from 'rxjs';
import { NzDirectionVHIType } from '../types';
import * as ɵngcc0 from '@angular/core';
export declare class NzMenuBaseService {
    isInDropDown: boolean;
    menuItemClick$: Subject<any>;
    theme$: Subject<unknown>;
    mode$: BehaviorSubject<NzDirectionVHIType>;
    inlineIndent$: BehaviorSubject<number>;
    theme: 'light' | 'dark';
    mode: NzDirectionVHIType;
    inlineIndent: number;
    menuOpen$: BehaviorSubject<boolean>;
    onMenuItemClick(menu: any): void;
    setMode(mode: NzDirectionVHIType): void;
    setTheme(theme: 'light' | 'dark'): void;
    setInlineIndent(indent: number): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzMenuBaseService>;
    static ɵprov: ɵngcc0.ɵɵInjectableDef<NzMenuBaseService>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibnotbWVudS1iYXNlLnNlcnZpY2UuZC50cyIsInNvdXJjZXMiOlsibnotbWVudS1iYXNlLnNlcnZpY2UuZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7O0FBQ0EiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgQWxpYmFiYS5jb20gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2dpdGh1Yi5jb20vTkctWk9SUk8vbmctem9ycm8tYW50ZC9ibG9iL21hc3Rlci9MSUNFTlNFXG4gKi9cbmltcG9ydCB7IEJlaGF2aW9yU3ViamVjdCwgU3ViamVjdCB9IGZyb20gJ3J4anMnO1xuaW1wb3J0IHsgTnpEaXJlY3Rpb25WSElUeXBlIH0gZnJvbSAnLi4vdHlwZXMnO1xuZXhwb3J0IGRlY2xhcmUgY2xhc3MgTnpNZW51QmFzZVNlcnZpY2Uge1xuICAgIGlzSW5Ecm9wRG93bjogYm9vbGVhbjtcbiAgICBtZW51SXRlbUNsaWNrJDogU3ViamVjdDxhbnk+O1xuICAgIHRoZW1lJDogU3ViamVjdDx1bmtub3duPjtcbiAgICBtb2RlJDogQmVoYXZpb3JTdWJqZWN0PE56RGlyZWN0aW9uVkhJVHlwZT47XG4gICAgaW5saW5lSW5kZW50JDogQmVoYXZpb3JTdWJqZWN0PG51bWJlcj47XG4gICAgdGhlbWU6ICdsaWdodCcgfCAnZGFyayc7XG4gICAgbW9kZTogTnpEaXJlY3Rpb25WSElUeXBlO1xuICAgIGlubGluZUluZGVudDogbnVtYmVyO1xuICAgIG1lbnVPcGVuJDogQmVoYXZpb3JTdWJqZWN0PGJvb2xlYW4+O1xuICAgIG9uTWVudUl0ZW1DbGljayhtZW51OiBhbnkpOiB2b2lkO1xuICAgIHNldE1vZGUobW9kZTogTnpEaXJlY3Rpb25WSElUeXBlKTogdm9pZDtcbiAgICBzZXRUaGVtZSh0aGVtZTogJ2xpZ2h0JyB8ICdkYXJrJyk6IHZvaWQ7XG4gICAgc2V0SW5saW5lSW5kZW50KGluZGVudDogbnVtYmVyKTogdm9pZDtcbn1cbiJdfQ==