/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { Platform } from '@angular/cdk/platform';
import { CdkVirtualScrollViewport } from '@angular/cdk/scrolling';
import { AfterContentInit, AfterViewInit, ChangeDetectorRef, ElementRef, EventEmitter, NgZone, OnChanges, OnDestroy, OnInit, QueryList, Renderer2, SimpleChanges, TemplateRef, TrackByFunction } from '@angular/core';
import { NzConfigService, NzSizeMDSType } from 'ng-zorro-antd/core';
import { NzI18nService } from 'ng-zorro-antd/i18n';
import { PaginationItemRenderContext } from 'ng-zorro-antd/pagination';
import { NzThComponent } from './nz-th.component';
import { NzTheadComponent } from './nz-thead.component';
import { NzVirtualScrollDirective } from './nz-virtual-scroll.directive';
import * as ɵngcc0 from '@angular/core';
export declare class NzTableComponent<T = any> implements OnInit, AfterViewInit, OnDestroy, OnChanges, AfterContentInit {
    nzConfigService: NzConfigService;
    private renderer;
    private ngZone;
    private cdr;
    private i18n;
    private platform;
    /** public data for ngFor tr */
    data: T[];
    locale: any;
    nzTheadComponent: NzTheadComponent;
    lastScrollLeft: number;
    headerBottomStyle: {};
    private destroy$;
    listOfNzThComponent: QueryList<NzThComponent>;
    tableHeaderElement: ElementRef;
    tableBodyElement: ElementRef;
    tableMainElement: ElementRef;
    cdkVirtualScrollElement: ElementRef;
    cdkVirtualScrollViewport: CdkVirtualScrollViewport;
    nzVirtualScrollDirective: NzVirtualScrollDirective;
    nzSize: NzSizeMDSType;
    nzShowTotal: TemplateRef<{
        $implicit: number;
        range: [number, number];
    }>;
    nzPageSizeOptions: number[];
    nzVirtualScroll: boolean;
    nzVirtualItemSize: number;
    nzVirtualMaxBufferPx: number;
    nzVirtualMinBufferPx: number;
    nzVirtualForTrackBy: TrackByFunction<T> | undefined;
    nzLoadingDelay: number;
    nzLoadingIndicator: TemplateRef<void>;
    nzTotal: number;
    nzTitle: string | TemplateRef<void>;
    nzFooter: string | TemplateRef<void>;
    nzNoResult: string | TemplateRef<void>;
    nzWidthConfig: string[];
    nzPageIndex: number;
    nzPageSize: number;
    nzData: T[];
    nzPaginationPosition: 'top' | 'bottom' | 'both';
    nzScroll: {
        x?: string | null;
        y?: string | null;
    };
    nzItemRender: TemplateRef<PaginationItemRenderContext>;
    itemRenderChild: TemplateRef<PaginationItemRenderContext>;
    readonly itemRender: TemplateRef<PaginationItemRenderContext>;
    nzFrontPagination: boolean;
    nzTemplateMode: boolean;
    nzBordered: boolean;
    nzShowPagination: boolean;
    nzLoading: boolean;
    nzShowSizeChanger: boolean;
    nzHideOnSinglePage: boolean;
    nzShowQuickJumper: boolean;
    nzSimple: boolean;
    readonly nzPageSizeChange: EventEmitter<number>;
    readonly nzPageIndexChange: EventEmitter<number>;
    readonly nzCurrentPageDataChange: EventEmitter<any[]>;
    readonly tableBodyNativeElement: HTMLElement;
    readonly tableHeaderNativeElement: HTMLElement;
    readonly cdkVirtualScrollNativeElement: HTMLElement;
    readonly mixTableBodyNativeElement: HTMLElement;
    emitPageSizeOrIndex(size: number, index: number): void;
    syncScrollTable(e: MouseEvent): void;
    setScrollPositionClassName(): void;
    setScrollName(position?: string): void;
    fitScrollBar(): void;
    updateFrontPaginationDataIfNeeded(isPageSizeOrDataChange?: boolean): void;
    constructor(nzConfigService: NzConfigService, renderer: Renderer2, ngZone: NgZone, cdr: ChangeDetectorRef, i18n: NzI18nService, platform: Platform, elementRef: ElementRef);
    ngOnInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngAfterViewInit(): void;
    ngAfterContentInit(): void;
    ngOnDestroy(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzTableComponent<any>>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzTableComponent<any>, "nz-table", ["nzTable"], {
    "nzPageSizeOptions": "nzPageSizeOptions";
    "nzVirtualScroll": "nzVirtualScroll";
    "nzVirtualItemSize": "nzVirtualItemSize";
    "nzVirtualMaxBufferPx": "nzVirtualMaxBufferPx";
    "nzVirtualMinBufferPx": "nzVirtualMinBufferPx";
    "nzLoadingDelay": "nzLoadingDelay";
    "nzTotal": "nzTotal";
    "nzWidthConfig": "nzWidthConfig";
    "nzPageIndex": "nzPageIndex";
    "nzPageSize": "nzPageSize";
    "nzData": "nzData";
    "nzPaginationPosition": "nzPaginationPosition";
    "nzScroll": "nzScroll";
    "nzFrontPagination": "nzFrontPagination";
    "nzTemplateMode": "nzTemplateMode";
    "nzShowPagination": "nzShowPagination";
    "nzLoading": "nzLoading";
    "nzSize": "nzSize";
    "nzShowTotal": "nzShowTotal";
    "nzVirtualForTrackBy": "nzVirtualForTrackBy";
    "nzLoadingIndicator": "nzLoadingIndicator";
    "nzTitle": "nzTitle";
    "nzFooter": "nzFooter";
    "nzNoResult": "nzNoResult";
    "nzItemRender": "nzItemRender";
    "nzBordered": "nzBordered";
    "nzShowSizeChanger": "nzShowSizeChanger";
    "nzHideOnSinglePage": "nzHideOnSinglePage";
    "nzShowQuickJumper": "nzShowQuickJumper";
    "nzSimple": "nzSimple";
}, {
    "nzPageSizeChange": "nzPageSizeChange";
    "nzPageIndexChange": "nzPageIndexChange";
    "nzCurrentPageDataChange": "nzCurrentPageDataChange";
}, ["nzVirtualScrollDirective", "listOfNzThComponent"]>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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