/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
/** get some code from https://github.com/angular/material2 */
import { AfterContentChecked, AfterContentInit, AfterViewInit, ChangeDetectorRef, ElementRef, EventEmitter, OnChanges, OnDestroy, OnInit, QueryList, Renderer2, SimpleChanges, TemplateRef } from '@angular/core';
import { Router } from '@angular/router';
import { NzConfigService, NzFourDirectionType, NzSizeLDSType, NzUpdateHostClassService } from 'ng-zorro-antd/core';
import { NzTabComponent } from './nz-tab.component';
import { NzTabsNavComponent } from './nz-tabs-nav.component';
import * as ɵngcc0 from '@angular/core';
export interface NzAnimatedInterface {
    inkBar: boolean;
    tabPane: boolean;
}
export declare class NzTabChangeEvent {
    index: number;
    tab: NzTabComponent;
}
export declare type NzTabPosition = NzFourDirectionType;
export declare type NzTabPositionMode = 'horizontal' | 'vertical';
export declare type NzTabType = 'line' | 'card';
export declare class NzTabSetComponent implements AfterContentChecked, OnInit, AfterViewInit, OnChanges, AfterContentInit, OnDestroy {
    nzConfigService: NzConfigService;
    private renderer;
    private nzUpdateHostClassService;
    private elementRef;
    private cdr;
    private router;
    private indexToSelect;
    private el;
    private _selectedIndex;
    /** Subscription to tabs being added/removed. */
    private tabsSubscription;
    /** Subscription to changes in the tab labels. */
    private tabLabelSubscription;
    private destroy$;
    tabPositionMode: NzTabPositionMode;
    listOfNzTabComponent: QueryList<NzTabComponent>;
    nzTabsNavComponent: NzTabsNavComponent;
    tabContent: ElementRef;
    nzTabBarExtraContent: TemplateRef<void>;
    nzShowPagination: boolean;
    nzAnimated: NzAnimatedInterface | boolean;
    nzHideAll: boolean;
    nzTabPosition: NzTabPosition;
    nzSize: NzSizeLDSType;
    nzTabBarGutter: number;
    nzTabBarStyle: {
        [key: string]: string;
    };
    nzType: NzTabType;
    nzLinkRouter: boolean;
    nzLinkExact: boolean;
    readonly nzOnNextClick: EventEmitter<void>;
    readonly nzOnPrevClick: EventEmitter<void>;
    readonly nzSelectChange: EventEmitter<NzTabChangeEvent>;
    readonly nzSelectedIndexChange: EventEmitter<number>;
    nzSelectedIndex: number | null;
    readonly inkBarAnimated: boolean;
    readonly tabPaneAnimated: boolean;
    setPosition(value: NzTabPosition): void;
    setClassMap(): void;
    clickLabel(index: number, disabled: boolean): void;
    createChangeEvent(index: number): NzTabChangeEvent;
    /** Clamps the given index to the bounds of 0 and the tabs length. */
    private clampTabIndex;
    private subscribeToTabLabels;
    constructor(nzConfigService: NzConfigService, renderer: Renderer2, nzUpdateHostClassService: NzUpdateHostClassService, elementRef: ElementRef, cdr: ChangeDetectorRef, router: Router);
    ngOnChanges(changes: SimpleChanges): void;
    ngOnInit(): void;
    ngAfterContentChecked(): void;
    ngAfterContentInit(): void;
    ngOnDestroy(): void;
    ngAfterViewInit(): void;
    private updateRouterActive;
    private findShouldActiveTabIndex;
    private isLinkActive;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzTabSetComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzTabSetComponent, "nz-tabset", ["nzTabset"], {
    "nzHideAll": "nzHideAll";
    "nzTabPosition": "nzTabPosition";
    "nzLinkRouter": "nzLinkRouter";
    "nzLinkExact": "nzLinkExact";
    "nzSelectedIndex": "nzSelectedIndex";
    "nzAnimated": "nzAnimated";
    "nzTabBarExtraContent": "nzTabBarExtraContent";
    "nzShowPagination": "nzShowPagination";
    "nzSize": "nzSize";
    "nzTabBarGutter": "nzTabBarGutter";
    "nzTabBarStyle": "nzTabBarStyle";
    "nzType": "nzType";
}, {
    "nzOnNextClick": "nzOnNextClick";
    "nzOnPrevClick": "nzOnPrevClick";
    "nzSelectChange": "nzSelectChange";
    "nzSelectedIndexChange": "nzSelectedIndexChange";
}, ["listOfNzTabComponent"]>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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